/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.solr.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.codelibs.core.msg.MessageFormatter;
import org.codelibs.solr.lib.exception.SolrLibException;
import org.codelibs.solr.lib.exception.SolrLibGroupNotAvailableException;
import org.codelibs.solr.lib.exception.SolrLibQueryException;
import org.codelibs.solr.lib.exception.SolrLibServerNotAvailableException;
import org.codelibs.solr.lib.exception.SolrLibServiceException;
import org.codelibs.solr.lib.policy.QueryType;
import org.codelibs.solr.lib.policy.StatusPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrGroup {
    private static final Logger logger = LoggerFactory.getLogger(SolrGroup.class);
    protected static final int MAX_LOAD_COUNT = 0x3FFFFFFF;
    protected Map<String, SolrServer> solrServerMap = new LinkedHashMap<String, SolrServer>();
    protected String groupName;
    protected ConcurrentHashMap<String, AtomicInteger> accessCountMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, AtomicInteger> errorCountMap = new ConcurrentHashMap();
    protected StatusPolicy statusPolicy;

    public void addServer(String name, SolrServer solrServer) {
        this.solrServerMap.put(name, solrServer);
    }

    public String[] getServerNames() {
        return this.solrServerMap.keySet().toArray(new String[this.solrServerMap.size()]);
    }

    public Collection<UpdateResponse> add(Collection<SolrInputDocument> docs) {
        return this.add(docs, -1);
    }

    public Collection<UpdateResponse> add(final Collection<SolrInputDocument> docs, final int commitWithinMs) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.add(docs, commitWithinMs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> add(SolrInputDocument doc) {
        return this.add(doc, -1);
    }

    public Collection<UpdateResponse> add(final SolrInputDocument doc, final int commitWithinMs) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.add(doc, commitWithinMs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> addBean(Object obj) {
        return this.addBean(obj, -1);
    }

    public Collection<UpdateResponse> addBean(final Object obj, final int commitWithinMs) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.addBean(obj, commitWithinMs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> addBean(Collection<?> beans) {
        return this.addBean(beans, -1);
    }

    public Collection<UpdateResponse> addBean(final Collection<?> beans, final int commitWithinMs) {
        this.checkStatus(QueryType.ADD);
        return this.updateQueryCallback(QueryType.ADD, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.addBeans(beans, commitWithinMs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> commit() {
        return this.commit(true, true, false);
    }

    public Collection<UpdateResponse> commit(boolean waitFlush, boolean waitSearcher) {
        return this.commit(waitFlush, waitSearcher, false);
    }

    public Collection<UpdateResponse> commit(boolean waitFlush, boolean waitSearcher, boolean softCommit) {
        return this.commit(waitFlush, waitSearcher, softCommit, false);
    }

    public Collection<UpdateResponse> commit(final boolean waitFlush, final boolean waitSearcher, final boolean softCommit, final boolean expungeDeletes) {
        this.checkStatus(QueryType.COMMIT);
        return this.updateQueryCallback(QueryType.COMMIT, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return new UpdateRequest().setAction(AbstractUpdateRequest.ACTION.COMMIT, waitFlush, waitSearcher, 1, softCommit, expungeDeletes).process(solrServer);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> rollback() {
        this.checkStatus(QueryType.ROLLBACK);
        return this.updateQueryCallback(QueryType.ROLLBACK, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.rollback();
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> deleteByQuery(String query) {
        return this.deleteByQuery(query, -1);
    }

    public Collection<UpdateResponse> deleteByQuery(final String query, final int commitWithinMs) {
        this.checkStatus(QueryType.DELETE);
        return this.updateQueryCallback(QueryType.DELETE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.deleteByQuery(query, commitWithinMs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> deleteById(String id) {
        return this.deleteById(id, -1);
    }

    public Collection<UpdateResponse> deleteById(final String id, final int commitWithinMs) {
        this.checkStatus(QueryType.DELETE);
        return this.updateQueryCallback(QueryType.DELETE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.deleteById(id, commitWithinMs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> deleteById(List<String> ids) {
        return this.deleteById(ids, -1);
    }

    public Collection<UpdateResponse> deleteById(final List<String> ids, final int commitWithinMs) {
        this.checkStatus(QueryType.DELETE);
        return this.updateQueryCallback(QueryType.DELETE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.deleteById(ids, commitWithinMs);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<UpdateResponse> optimize() {
        return this.optimize(true, true, 1);
    }

    public Collection<UpdateResponse> optimize(boolean waitFlush, boolean waitSearcher) {
        return this.optimize(waitFlush, waitSearcher, 1);
    }

    public Collection<UpdateResponse> optimize(final boolean waitFlush, final boolean waitSearcher, final int maxSegments) {
        this.checkStatus(QueryType.OPTIMIZE);
        return this.updateQueryCallback(QueryType.OPTIMIZE, new UpdateProcessCallback<UpdateResponse>(){

            @Override
            public UpdateResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.optimize(waitFlush, waitSearcher, maxSegments);
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public Collection<SolrPingResponse> ping() {
        this.checkStatus(QueryType.PING);
        return this.updateQueryCallback(QueryType.PING, new UpdateProcessCallback<SolrPingResponse>(){

            @Override
            public SolrPingResponse callback(SolrServer solrServer) {
                try {
                    return solrServer.ping();
                }
                catch (Exception e) {
                    throw new SolrLibException(e);
                }
            }
        });
    }

    public QueryResponse queryAndStreamResponse(final SolrParams params, final StreamingResponseCallback callback) {
        this.checkStatus(QueryType.QUERY);
        SolrLibServiceException fsqe = null;
        int maxRetryCount = this.statusPolicy.getMaxRetryCount(QueryType.QUERY);
        for (int i = 0; i < maxRetryCount; ++i) {
            try {
                return this.queryInternal(QueryType.QUERY, params, new UpdateProcessCallback<QueryResponse>(){

                    @Override
                    public QueryResponse callback(SolrServer solrServer) throws Exception {
                        return solrServer.queryAndStreamResponse(params, callback);
                    }
                });
            }
            catch (SolrLibQueryException | SolrLibServerNotAvailableException e) {
                throw e;
            }
            catch (Exception e) {
                if (fsqe == null) {
                    fsqe = new SolrLibServiceException("ESL0011", new Object[]{params.toString()});
                }
                fsqe.addException(e);
                this.statusPolicy.sleep(QueryType.QUERY);
                continue;
            }
        }
        throw fsqe;
    }

    public QueryResponse query(SolrParams params) {
        return this.query(params, SolrRequest.METHOD.GET);
    }

    public QueryResponse query(final SolrParams params, final SolrRequest.METHOD method) {
        this.checkStatus(QueryType.QUERY);
        SolrLibServiceException fsqe = null;
        int maxRetryCount = this.statusPolicy.getMaxRetryCount(QueryType.QUERY);
        for (int i = 0; i < maxRetryCount; ++i) {
            try {
                return this.queryInternal(QueryType.QUERY, params, new UpdateProcessCallback<QueryResponse>(){

                    @Override
                    public QueryResponse callback(SolrServer solrServer) throws Exception {
                        return solrServer.query(params, method);
                    }
                });
            }
            catch (SolrLibQueryException | SolrLibServerNotAvailableException e) {
                throw e;
            }
            catch (Exception e) {
                if (fsqe == null) {
                    fsqe = new SolrLibServiceException("ESL0011", new Object[]{params.toString()});
                }
                fsqe.addException(e);
                this.statusPolicy.sleep(QueryType.QUERY);
                continue;
            }
        }
        throw fsqe;
    }

    public NamedList<Object> request(final SolrRequest request) {
        this.checkStatus(QueryType.REQUEST);
        SolrLibServiceException fsqe = null;
        int maxRetryCount = this.statusPolicy.getMaxRetryCount(QueryType.REQUEST);
        for (int i = 0; i < maxRetryCount; ++i) {
            try {
                return this.queryInternal(QueryType.REQUEST, request, new UpdateProcessCallback<NamedList<Object>>(){

                    @Override
                    public NamedList<Object> callback(SolrServer solrServer) throws Exception {
                        return solrServer.request(request);
                    }
                });
            }
            catch (SolrLibQueryException | SolrLibServerNotAvailableException e) {
                throw e;
            }
            catch (Exception e) {
                if (fsqe == null) {
                    fsqe = new SolrLibServiceException("ESL0011", new Object[]{request.toString()});
                }
                fsqe.addException(e);
                this.statusPolicy.sleep(QueryType.REQUEST);
                continue;
            }
        }
        throw fsqe;
    }

    protected <RESULT> RESULT queryInternal(QueryType queryType, Object selectQuery, UpdateProcessCallback<RESULT> callback) {
        String solrServerName = null;
        try {
            SolrServer solrServer = null;
            AtomicInteger minValue = null;
            for (Map.Entry<String, SolrServer> entry : this.solrServerMap.entrySet()) {
                AtomicInteger count = this.accessCountMap.get(entry.getKey());
                if (count == null) {
                    count = new AtomicInteger(1);
                    AtomicInteger accessCount = this.accessCountMap.putIfAbsent(entry.getKey(), count);
                    if (accessCount != null) {
                        accessCount.getAndIncrement();
                        count = accessCount;
                    }
                }
                if (minValue != null && count.get() >= minValue.get() || !this.statusPolicy.isActive(queryType, entry.getKey())) continue;
                minValue = count;
                solrServerName = entry.getKey();
                solrServer = entry.getValue();
            }
            if (solrServer == null) {
                throw new SolrLibException("ESL0002", new Object[]{this.groupName});
            }
            if (minValue.getAndIncrement() > 0x3FFFFFFF) {
                this.accessCountMap.clear();
            }
            if (!this.statusPolicy.isActive(queryType, solrServerName)) {
                throw new SolrLibServerNotAvailableException(this.groupName, solrServerName);
            }
            RESULT result = callback.callback(solrServer);
            this.errorCountMap.remove(solrServerName);
            return result;
        }
        catch (Exception e) {
            throw this.getQueryException(queryType, selectQuery, solrServerName, e);
        }
    }

    protected SolrLibException getQueryException(QueryType queryType, Object selectQuery, String solrServerName, Exception e) {
        if (e instanceof SolrException) {
            switch (((SolrException)e).code()) {
                case 404: {
                    throw new SolrLibServerNotAvailableException(this.groupName, solrServerName);
                }
                case 400: 
                case 500: {
                    throw new SolrLibQueryException("ESL0013", new Object[]{selectQuery}, e);
                }
            }
        }
        if (solrServerName != null) {
            AtomicInteger count;
            AtomicInteger errorCount = this.errorCountMap.get(solrServerName);
            if (errorCount == null && (count = this.errorCountMap.putIfAbsent(solrServerName, errorCount = new AtomicInteger(0))) != null) {
                errorCount = count;
            }
            int maxErrorCount = this.statusPolicy.getMaxErrorCount(queryType);
            if (errorCount.get() > maxErrorCount) {
                this.statusPolicy.deactivate(queryType, solrServerName);
                this.errorCountMap.remove(solrServerName);
                return new SolrLibException("ESL0003", new Object[]{solrServerName, this.groupName, errorCount, maxErrorCount}, e);
            }
            errorCount.getAndIncrement();
            return new SolrLibException("ESL0004", new Object[]{solrServerName, this.groupName, errorCount, maxErrorCount}, e);
        }
        return new SolrLibException("ESL0005", new Object[]{selectQuery.toString()}, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Collection<T> updateQueryCallback(QueryType queryType, UpdateProcessCallback<T> upc) {
        ArrayList resultList = new ArrayList();
        StatusPolicy statusPolicy = this.statusPolicy;
        synchronized (statusPolicy) {
            for (Map.Entry<String, SolrServer> entry : this.solrServerMap.entrySet()) {
                String serverName = entry.getKey();
                if (!this.statusPolicy.isActive(queryType, serverName)) continue;
                this.executeUpdateQuery(queryType, upc, resultList, entry, serverName, 0);
            }
        }
        return resultList;
    }

    protected <T> void executeUpdateQuery(QueryType queryType, UpdateProcessCallback<T> upc, List<T> resultList, Map.Entry<String, SolrServer> entry, String serverName, int retryCount) {
        try {
            resultList.add(upc.callback(entry.getValue()));
        }
        catch (Exception e) {
            logger.warn(MessageFormatter.getSimpleMessage((String)"WSL0003", (Object[])new Object[]{serverName, upc, retryCount}), (Throwable)e);
            if (retryCount > this.statusPolicy.getMaxRetryCount(queryType)) {
                this.statusPolicy.deactivate(queryType, serverName);
            }
            this.statusPolicy.sleep(queryType);
            this.executeUpdateQuery(queryType, upc, resultList, entry, serverName, retryCount + 1);
        }
    }

    public boolean isActive(QueryType queryType) {
        return this.statusPolicy.isActive(queryType, this.solrServerMap.keySet());
    }

    protected void checkStatus(QueryType queryType) {
        if (!this.statusPolicy.isActive(queryType, this.solrServerMap.keySet())) {
            throw new SolrLibGroupNotAvailableException(this.groupName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus() {
        StatusPolicy statusPolicy = this.statusPolicy;
        synchronized (statusPolicy) {
            for (Map.Entry<String, SolrServer> entry : this.solrServerMap.entrySet()) {
                String serverName = entry.getKey();
                if (this.statusPolicy.isActive(QueryType.PING, serverName)) continue;
                try {
                    SolrPingResponse pingResponse = entry.getValue().ping();
                    if (pingResponse.getStatus() == 0) {
                        this.statusPolicy.activate(QueryType.PING, serverName);
                        continue;
                    }
                    logger.warn(MessageFormatter.getSimpleMessage((String)"WSL0002", (Object[])new Object[]{serverName, pingResponse.getStatus()}));
                    this.statusPolicy.deactivate(QueryType.PING, serverName);
                }
                catch (Exception e) {
                    logger.warn(MessageFormatter.getSimpleMessage((String)"WSL0001", (Object[])new Object[]{serverName}), (Throwable)e);
                    this.statusPolicy.deactivate(QueryType.PING, serverName);
                }
            }
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public StatusPolicy getStatusPolicy() {
        return this.statusPolicy;
    }

    public void setStatusPolicy(StatusPolicy statusPolicy) {
        this.statusPolicy = statusPolicy;
    }

    protected static interface UpdateProcessCallback<V> {
        public V callback(SolrServer var1) throws Exception;
    }
}

