/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.resource;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.Form;
import org.restlet.engine.Method;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.representation.Representation;
import org.restlet.resource.ServerResource;
import org.restlet.service.ConverterService;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    private static final ConcurrentMap<Class<?>, List<AnnotationInfo>> cache = new ConcurrentHashMap();

    private static List<AnnotationInfo> addAnnotationDescriptors(List<AnnotationInfo> descriptors, Class<?> resourceClass, Class<?> initialResourceClass, java.lang.reflect.Method javaMethod) {
        List<AnnotationInfo> result = descriptors;
        if (result == null) {
            result = new CopyOnWriteArrayList<AnnotationInfo>();
        }
        for (Annotation annotation : javaMethod.getAnnotations()) {
            Method methodAnnotation = annotation.annotationType().getAnnotation(Method.class);
            if (methodAnnotation == null) continue;
            org.restlet.data.Method restletMethod = org.restlet.data.Method.valueOf(methodAnnotation.value());
            String toString = ((Object)annotation).toString();
            int startIndex = annotation.annotationType().getCanonicalName().length() + 8;
            int endIndex = toString.length() - 1;
            String value = null;
            if (endIndex > startIndex && "".equals(value = toString.substring(startIndex, endIndex))) {
                value = null;
            }
            result.add(new AnnotationInfo(initialResourceClass, restletMethod, javaMethod, value));
        }
        return result;
    }

    private static List<AnnotationInfo> addAnnotations(List<AnnotationInfo> descriptors, Class<?> clazz, Class<?> initialClass) {
        List<AnnotationInfo> result = descriptors;
        if (clazz != null && !ServerResource.class.equals(clazz)) {
            Class<?>[] interfaces;
            if (result == null) {
                result = new CopyOnWriteArrayList<AnnotationInfo>();
            }
            if (clazz.isInterface()) {
                for (java.lang.reflect.Method javaMethod : clazz.getMethods()) {
                    AnnotationUtils.addAnnotationDescriptors(result, clazz, initialClass, javaMethod);
                }
            } else {
                for (java.lang.reflect.Method javaMethod : clazz.getDeclaredMethods()) {
                    AnnotationUtils.addAnnotationDescriptors(result, clazz, initialClass, javaMethod);
                }
            }
            if ((interfaces = clazz.getInterfaces()) != null) {
                for (Class<?> interfaceClass : interfaces) {
                    result = AnnotationUtils.addAnnotations(result, interfaceClass, initialClass);
                }
            }
            AnnotationUtils.addAnnotations(result, clazz.getSuperclass(), initialClass);
        }
        return result;
    }

    public static void clearCache() {
        cache.clear();
    }

    public static AnnotationInfo getAnnotation(List<AnnotationInfo> annotations, java.lang.reflect.Method javaMethod) {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!annotationInfo.getJavaMethod().equals(javaMethod)) continue;
                return annotationInfo;
            }
        }
        return null;
    }

    public static AnnotationInfo getAnnotation(List<AnnotationInfo> annotations, org.restlet.data.Method restletMethod, Form query, Representation entity, MetadataService metadataService, ConverterService converterService) {
        if (annotations != null) {
            for (AnnotationInfo annotationInfo : annotations) {
                if (!annotationInfo.isCompatible(restletMethod, query, entity, metadataService, converterService)) continue;
                return annotationInfo;
            }
        }
        return null;
    }

    public static List<AnnotationInfo> getAnnotations(Class<?> clazz) {
        List<AnnotationInfo> prev;
        List<AnnotationInfo> result = (List<AnnotationInfo>)cache.get(clazz);
        if (result == null && (prev = cache.putIfAbsent(clazz, result = AnnotationUtils.addAnnotations(result, clazz, clazz))) != null) {
            result = prev;
        }
        return result;
    }

    public static List<AnnotationInfo> getAnnotations(Class<?> clazz, java.lang.reflect.Method javaMethod) {
        return AnnotationUtils.addAnnotationDescriptors(null, clazz, clazz, javaMethod);
    }

    private AnnotationUtils() {
    }
}

