/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;

abstract class DocValuesUpdate {
    private static final int RAW_SIZE_IN_BYTES = 8 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 32;
    final DocValuesFieldUpdates.Type type;
    final Term term;
    final String field;
    final Object value;
    int docIDUpto = -1;

    protected DocValuesUpdate(DocValuesFieldUpdates.Type type, Term term, String field, Object value) {
        this.type = type;
        this.term = term;
        this.field = field;
        this.value = value;
    }

    abstract long valueSizeInBytes();

    final int sizeInBytes() {
        int sizeInBytes = RAW_SIZE_IN_BYTES;
        sizeInBytes += this.term.field.length() * 2;
        sizeInBytes += this.term.bytes.bytes.length;
        sizeInBytes += this.field.length() * 2;
        sizeInBytes = (int)((long)sizeInBytes + this.valueSizeInBytes());
        return sizeInBytes;
    }

    public String toString() {
        return "term=" + this.term + ",field=" + this.field + ",value=" + this.value;
    }

    static final class NumericDocValuesUpdate
    extends DocValuesUpdate {
        static final Long MISSING = new Long(0L);

        NumericDocValuesUpdate(Term term, String field, Long value) {
            super(DocValuesFieldUpdates.Type.NUMERIC, term, field, value == null ? MISSING : value);
        }

        @Override
        long valueSizeInBytes() {
            return 8L;
        }
    }

    static final class BinaryDocValuesUpdate
    extends DocValuesUpdate {
        private static final long RAW_VALUE_SIZE_IN_BYTES = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF;
        static final BytesRef MISSING = new BytesRef();

        BinaryDocValuesUpdate(Term term, String field, BytesRef value) {
            super(DocValuesFieldUpdates.Type.BINARY, term, field, value == null ? MISSING : value);
        }

        @Override
        long valueSizeInBytes() {
            return RAW_VALUE_SIZE_IN_BYTES + (long)((BytesRef)this.value).bytes.length;
        }
    }
}

