/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.apache.pdfbox.util.ResourceLoader;

public class FontManager {
    private static HashMap<String, Font> envFonts = new HashMap();
    private static final String standardFont = "helvetica";
    private static Properties fontMapping = new Properties();

    private FontManager() {
    }

    public static Font getStandardFont() {
        return FontManager.getAwtFont(standardFont);
    }

    public static Font getAwtFont(String font) {
        String fontname = FontManager.normalizeFontname(font);
        if (envFonts.containsKey(fontname)) {
            return envFonts.get(fontname);
        }
        return null;
    }

    private static void loadFonts() {
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            String family = FontManager.normalizeFontname(font.getFamily());
            String psname = FontManager.normalizeFontname(font.getPSName());
            if (FontManager.isBoldItalic(font)) {
                envFonts.put(family + "bolditalic", font);
            } else if (FontManager.isBold(font)) {
                envFonts.put(family + "bold", font);
            } else if (FontManager.isItalic(font)) {
                envFonts.put(family + "italic", font);
            } else {
                envFonts.put(family, font);
            }
            if (family.equals(psname)) continue;
            envFonts.put(FontManager.normalizeFontname(font.getPSName()), font);
        }
    }

    private static String normalizeFontname(String fontname) {
        String normalizedFontname = fontname.toLowerCase().replaceAll(" ", "").replaceAll(",", "").replaceAll("-", "");
        if (normalizedFontname.indexOf("+") > -1) {
            normalizedFontname = normalizedFontname.substring(normalizedFontname.indexOf("+") + 1);
        }
        boolean isBold = normalizedFontname.indexOf("bold") > -1;
        boolean isItalic = normalizedFontname.indexOf("italic") > -1 || normalizedFontname.indexOf("oblique") > -1;
        normalizedFontname = normalizedFontname.toLowerCase().replaceAll("bold", "").replaceAll("italic", "").replaceAll("oblique", "");
        if (isBold) {
            normalizedFontname = normalizedFontname + "bold";
        }
        if (isItalic) {
            normalizedFontname = normalizedFontname + "italic";
        }
        return normalizedFontname;
    }

    private static boolean addFontMapping(String font, String mappedName) {
        String fontname = FontManager.normalizeFontname(font);
        if (envFonts.containsKey(fontname)) {
            return false;
        }
        String mappedFontname = FontManager.normalizeFontname(mappedName);
        if (!envFonts.containsKey(mappedFontname)) {
            return false;
        }
        envFonts.put(fontname, envFonts.get(mappedFontname));
        return true;
    }

    private static void loadFontMapping() {
        boolean addedMapping = true;
        while (addedMapping) {
            int counter = 0;
            Enumeration<Object> keys = fontMapping.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!FontManager.addFontMapping(key, (String)fontMapping.get(key))) continue;
                ++counter;
            }
            if (counter != 0) continue;
            addedMapping = false;
        }
    }

    private static void loadBasefontMapping() {
        if (!FontManager.addFontMapping("Times-Roman", "TimesNewRoman")) {
            FontManager.addFontMapping("Times-Roman", "Serif");
        }
        if (!FontManager.addFontMapping("Times-Bold", "TimesNewRoman,Bold")) {
            FontManager.addFontMapping("Times-Bold", "Serif.bold");
        }
        if (!FontManager.addFontMapping("Times-Italic", "TimesNewRoman,Italic")) {
            FontManager.addFontMapping("Times-Italic", "Serif.italic");
        }
        if (!FontManager.addFontMapping("Times-BoldItalic", "TimesNewRoman,Bold,Italic")) {
            FontManager.addFontMapping("Times-BoldItalic", "Serif.bolditalic");
        }
        if (!FontManager.addFontMapping("Helvetica", "Helvetica")) {
            FontManager.addFontMapping("Helvetica", "SansSerif");
        }
        if (!FontManager.addFontMapping("Helvetica-Bold", "Helvetica,Bold")) {
            FontManager.addFontMapping("Helvetica-Bold", "SansSerif.bold");
        }
        if (!FontManager.addFontMapping("Helvetica-Oblique", "Helvetica,Italic")) {
            FontManager.addFontMapping("Helvetica-Oblique", "SansSerif.italic");
        }
        if (!FontManager.addFontMapping("Helvetica-BoldOblique", "Helvetica,Bold,Italic")) {
            FontManager.addFontMapping("Helvetica-BoldOblique", "SansSerif.bolditalic");
        }
        if (!FontManager.addFontMapping("Courier", "Courier")) {
            FontManager.addFontMapping("Courier", "Monospaced");
        }
        if (!FontManager.addFontMapping("Courier-Bold", "Courier,Bold")) {
            FontManager.addFontMapping("Courier-Bold", "Monospaced.bold");
        }
        if (!FontManager.addFontMapping("Courier-Oblique", "Courier,Italic")) {
            FontManager.addFontMapping("Courier-Oblique", "Monospaced.italic");
        }
        if (!FontManager.addFontMapping("Courier-BoldOblique", "Courier,Bold,Italic")) {
            FontManager.addFontMapping("Courier-BoldOblique", "Monospaced.bolditalic");
        }
        FontManager.addFontMapping("Symbol", "StandardSymbolsL");
        FontManager.addFontMapping("ZapfDingbats", "Dingbats");
    }

    private static boolean isBoldItalic(Font font) {
        return FontManager.isBold(font) && FontManager.isItalic(font);
    }

    private static boolean isBold(Font font) {
        String name = font.getName().toLowerCase();
        if (name.indexOf("bold") > -1) {
            return true;
        }
        String psname = font.getPSName().toLowerCase();
        return psname.indexOf("bold") > -1;
    }

    private static boolean isItalic(Font font) {
        String name = font.getName().toLowerCase();
        if (name.indexOf("italic") > -1 || name.indexOf("oblique") > -1) {
            return true;
        }
        String psname = font.getPSName().toLowerCase();
        return psname.indexOf("italic") > -1 || psname.indexOf("oblique") > -1;
    }

    static {
        try {
            ResourceLoader.loadProperties("org/apache/pdfbox/resources/FontMapping.properties", fontMapping);
        }
        catch (IOException io) {
            io.printStackTrace();
            throw new RuntimeException("Error loading font mapping");
        }
        FontManager.loadFonts();
        FontManager.loadBasefontMapping();
        FontManager.loadFontMapping();
    }
}

