/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.coll;

import com.ibm.icu.impl.ICUData;
import com.ibm.icu.impl.coll.CollationData;
import com.ibm.icu.impl.coll.CollationDataReader;
import com.ibm.icu.impl.coll.CollationSettings;
import com.ibm.icu.impl.coll.CollationTailoring;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;

public final class CollationRoot {
    private static final CollationTailoring rootSingleton;
    private static final RuntimeException exception;

    public static final CollationTailoring getRoot() {
        if (exception != null) {
            throw exception;
        }
        return rootSingleton;
    }

    public static final CollationData getData() {
        CollationTailoring root = CollationRoot.getRoot();
        return root.data;
    }

    static final CollationSettings getSettings() {
        CollationTailoring root = CollationRoot.getRoot();
        return root.settings.readOnly();
    }

    static {
        CollationTailoring t = new CollationTailoring(null);
        String path = "data/icudt53b/coll/ucadata.icu";
        InputStream inBytes = ICUData.getRequiredStream(path);
        RuntimeException e2 = null;
        try {
            CollationDataReader.read(null, inBytes, t);
        }
        catch (IOException e) {
            t = null;
            e2 = new MissingResourceException("IOException while reading CLDR root data", "CollationRoot", path);
        }
        catch (RuntimeException e) {
            t = null;
            e2 = e;
        }
        rootSingleton = t;
        exception = e2;
    }
}

