/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors.scanner;

import jp.sourceforge.ecurlipse.editor.editors.CurlColorManager;
import jp.sourceforge.ecurlipse.editor.editors.CurlWhitespaceDetector;
import jp.sourceforge.ecurlipse.editor.editors.def.DefaultEditorColor;
import jp.sourceforge.ecurlipse.editor.editors.rule.CurlBracketRule;
import jp.sourceforge.ecurlipse.editor.editors.rule.CurlClassNameRule;
import jp.sourceforge.ecurlipse.editor.editors.rule.CurlConstantWordRule;
import jp.sourceforge.ecurlipse.editor.editors.rule.CurlDistanceRule;
import jp.sourceforge.ecurlipse.editor.editors.rule.CurlReserveWordRule;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.swt.graphics.RGB;

public class CurlScanner
extends RuleBasedScanner {
    private CurlColorManager colorManager;

    public CurlScanner(CurlColorManager manager) {
        this.colorManager = manager;
        IToken string = this.createToken("jp.sourceforge.ecurlipse.editor.StringColor");
        IToken distance = this.createToken("jp.sourceforge.ecurlipse.editor.DistanceColor");
        IToken bracket = this.createToken(DefaultEditorColor.BRACKET);
        IToken keyword = this.createToken("jp.sourceforge.ecurlipse.editor.KeywordColor");
        IToken clazz = this.createToken("jp.sourceforge.ecurlipse.editor.ClassColor");
        IToken constants = this.createToken("jp.sourceforge.ecurlipse.editor.ConstantColor");
        IRule[] rules = new IRule[7];
        int i = 0;
        rules[i++] = new WhitespaceRule((IWhitespaceDetector)new CurlWhitespaceDetector());
        rules[i++] = new SingleLineRule("\"", "\"", string, '\\');
        rules[i++] = new CurlReserveWordRule(keyword);
        rules[i++] = new CurlConstantWordRule(constants);
        rules[i++] = new CurlClassNameRule(clazz);
        rules[i++] = new CurlDistanceRule(distance);
        rules[i++] = new CurlBracketRule(bracket);
        this.setRules(rules);
    }

    private IToken createToken(RGB rgb) {
        return new Token((Object)new TextAttribute(this.colorManager.getColor(rgb)));
    }

    private IToken createToken(String color) {
        return this.colorManager.getToken(color);
    }
}

