/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor.editors.rule;

import jp.sourceforge.ecurlipse.editor.editors.CurlColorManager;
import jp.sourceforge.ecurlipse.editor.editors.def.CurlColor;
import jp.sourceforge.ecurlipse.editor.editors.rule.RuleUtil;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;

public class CurlColorRule
implements IRule {
    public IToken evaluate(ICharacterScanner scanner) {
        char c = (char)scanner.read();
        StringBuffer sb = new StringBuffer();
        if (c != '\"') {
            scanner.unread();
            return Token.UNDEFINED;
        }
        do {
            sb.append(c);
        } while ((c = (char)scanner.read()) != '\"' || c == '\n');
        sb.append(c);
        StringBuffer colorSb = new StringBuffer(sb.toString());
        colorSb.deleteCharAt(sb.length() - 1).deleteCharAt(0).toString();
        String color = colorSb.toString();
        Token result = null;
        Color foreground = null;
        Color background = null;
        if (CurlColorManager.getColorMap().containsKey(color)) {
            foreground = color.equals("white") || color.equals("beige") || color.equals("wheat") || color.equals("pink") || color.equals("silver") || color.equals("yellow") || color.equals("cyan") ? CurlColor.BLACK : CurlColor.WHITE;
            background = CurlColorManager.getColorByName(color);
            result = new Token((Object)new TextAttribute(foreground, background, 0));
            return result;
        }
        if (this.isColorString(color)) {
            background = CurlColorManager.getColorByCode(color);
            int margeColor = background.getRed() + background.getGreen() + background.getBlue();
            if (margeColor < 380) {
                foreground = CurlColor.WHITE;
            }
            result = new Token((Object)new TextAttribute(foreground, background, 0));
            return result;
        }
        int i = 0;
        while (i < sb.length()) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }

    private boolean isColorString(String color) {
        if (color.length() != 7) {
            return false;
        }
        if (color.charAt(0) != '#') {
            return false;
        }
        int i = 1;
        while (i < 7) {
            char c = color.charAt(i);
            if (!RuleUtil.isHexChar(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

