/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.ecurlipse.editor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import jp.sourceforge.ecurlipse.editor.editors.CurlColorManager;
import jp.sourceforge.ecurlipse.editor.editors.def.DefaultEditorColor;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CurlEditorPlugin
extends AbstractUIPlugin {
    private static Logger log;
    private static Set reserveWordSet;
    private static Set proposalWordSet;
    private static CurlEditorPlugin plugin;
    private ResourceBundle resourceBundle;
    private CurlColorManager colorManger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ecurlipse.editor.CurlEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public CurlEditorPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        log.info((Object)"CurlEditorPlugin Constructor");
        try {
            this.resourceBundle = ResourceBundle.getBundle("jp.sourceforge.ecurlipse.editor.CurlEditorPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        this.colorManger = new CurlColorManager();
    }

    public static CurlEditorPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CurlEditorPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private static void initReserveWordSet() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ecurlipse.editor.CurlEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("/curlReserveWord.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        reserveWordSet = new TreeSet();
        String line = null;
        try {
            line = reader.readLine();
            while (line != null) {
                reserveWordSet.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Set getReserveWordSet() {
        if (reserveWordSet == null) {
            CurlEditorPlugin.initReserveWordSet();
        }
        return reserveWordSet;
    }

    private static void initProposalWordSet() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jp.sourceforge.ecurlipse.editor.CurlEditorPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        InputStream stream = clazz.getResourceAsStream("/curlProposalWord.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String norwegian = "< a,A< b,B< c,C< d,D< e,E< f,F< g,G< h,H< i,I< j,J< k,K< l,L< m,M< n,N< o,O< p,P< q,Q< r,R< s,S< t,T< u,U< v,V< w,W< x,X< y,Y< z,Z";
        RuleBasedCollator myNorwegian = null;
        try {
            myNorwegian = new RuleBasedCollator(norwegian);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        proposalWordSet = new TreeSet<Object>(myNorwegian);
        String line = "";
        try {
            line = reader.readLine();
            while (line != null) {
                proposalWordSet.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Set getProposalWordSet() {
        if (proposalWordSet == null) {
            CurlEditorPlugin.initProposalWordSet();
        }
        return proposalWordSet;
    }

    public CurlColorManager getColorManager() {
        return this.colorManger;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        store.setDefault("jp.sourceforge.ecurlipse.editor.CommentColor", StringConverter.asString((RGB)DefaultEditorColor.COMMENT));
        store.setDefault("jp.sourceforge.ecurlipse.editor.StringColor", StringConverter.asString((RGB)DefaultEditorColor.STRING));
        store.setDefault("jp.sourceforge.ecurlipse.editor.DefaultColor", StringConverter.asString((RGB)DefaultEditorColor.DEFAULT));
        store.setDefault("jp.sourceforge.ecurlipse.editor.KeywordColor", StringConverter.asString((RGB)DefaultEditorColor.KEYWORD));
        store.setDefault("jp.sourceforge.ecurlipse.editor.BracketColor", StringConverter.asString((RGB)DefaultEditorColor.BRACKET));
        store.setDefault("jp.sourceforge.ecurlipse.editor.DistanceColor", StringConverter.asString((RGB)DefaultEditorColor.DISTANCE));
        store.setDefault("jp.sourceforge.ecurlipse.editor.ClassColor", StringConverter.asString((RGB)DefaultEditorColor.CLASS));
        store.setDefault("jp.sourceforge.ecurlipse.editor.ConstantColor", StringConverter.asString((RGB)DefaultEditorColor.CONSTANT));
    }
}

