unit ecma_activex;

//ActiveX Object
//2001/05/03
//by Wolfy

{$IFDEF VER130}
{$ELSE}
  {$WARN SYMBOL_PLATFORM OFF}
  {$WARN UNIT_PLATFORM OFF}
{$ENDIF}


interface

uses
  windows,classes,sysutils,dialogs,syncobjs,gsocketmisc,
  ecma_type,ecma_expr,hashtable,ecma_misc,ecma_object,myclasses,
  activex,comobj,AxCtrls;

type
  TJActiveXObject = class(TJObject)
  private
    FHash: TIntegerHashTable;
    FDispatch: IDispatch;
  protected
    function GetPropertyList: String; override;
  public
    constructor Create(AFactory: TJObjectFactory; Param: TJValueList); override;
    destructor Destroy; override;
    function GetValue(S: String; ArrayStyle: Boolean): TJValue; override;
    procedure SetValue(S: String; Value: TJValue; ArrayStyle: Boolean); override;
    function DispIdToString(Id: TDispId): String;
  published
    property disp: IDispatch read FDispatch write FDispatch;
  end;



implementation

{ TJActiveXObject }

constructor TJActiveXObject.Create(AFactory: TJObjectFactory;
  Param: TJValueList);
var
  v: TJValue;
  s: String;
begin
  inherited;
  RegistName('ActiveXObject');

  FHash := TIntegerHashTable.Create(100);
  
  if IsParam1(Param) then
  begin
    v := Param[0];
    if IsDispatch(@v) then
      FDispatch := AsDispatch(@v)
    else begin
      s := AsString(@v);
      try
        FDispatch := CreateOleObject(s);
      except
        raise EJThrow.Create(E_ACTIVEX,'create error ' + s);
      end;
    end;
  end;
end;

destructor TJActiveXObject.Destroy;
begin
  FreeAndNil(FHash);
  FDispatch := nil;
  inherited;
end;

function TJActiveXObject.DispIdToString(Id: TDispId): String;
var
  sl: TStringList;
  i: Integer;
begin
  Result := '';
  sl := FHash.KeyList;
  for i := 0 to sl.Count - 1 do
  begin
    if FHash[sl[i]] = Id then
    begin
      Result := sl[i];
      Break;
    end;
  end;
end;

function TJActiveXObject.GetPropertyList: String;
var
  sl: TStringList;
begin
  sl := TStringList.Create;
  try
    EnumDispatchProperties(FDispatch,GUID_NULL,VT_EMPTY,sl);
    Result := sl.Text;
  finally
    sl.Free;
  end;
end;

function TJActiveXObject.GetValue(S: String; ArrayStyle: Boolean): TJValue;
var
  ws: WideString;
  di: TDispID;
  param: TDispParams;
  ret: OleVariant;
  func: TJFunction;
begin
  EmptyValue(Result);
  //membersɂȂΏI
  if HasKey(S) or HasDefaultProperty(S)  then
  begin
    Result := inherited GetValue(S,ArrayStyle);
    Exit;
  end;

  if FHash.HasKey(S) then
    di := FHash[S]
  else begin
    ws := S;
    try
      OLECheck(FDispatch.GetIDsOfNames(
        GUID_NULL,@ws,1,GetUserDefaultLCID,@di));
    except
      raise EJThrow.Create(E_ACTIVEX,S);
    end;
    //LbV
    FHash[S] := di;
  end;

  param.rgvarg := nil;
  param.rgdispidNamedArgs := nil;
  param.cArgs := 0;
  param.cNamedArgs := 0;
  VariantInit(ret);
  //propertyĂяoȂ
  try
    OLECheck(FDispatch.Invoke(
      di,GUID_NULL,GetUserDefaultLCID,DISPATCH_PROPERTYGET,param,@ret,nil,nil));
    Result := VariantToValue(ret,FFactory);
  except
    func.FuncType := ftActiveX;
    func.This := Self;
{$IFNDEF AX}
    func.AXMethod.Dispid := di;
    func.AXMethod.Parent := FDispatch;
{$ENDIF}
    //o^
    Result := FFuncFactory.BuildFunction(func);
    Members[S] := Result;
  end;
end;

procedure TJActiveXObject.SetValue(S: String; Value: TJValue;
  ArrayStyle: Boolean);
var
  ws: WideString;
  di,diput: TDispID;
  param: TDispParams;
  v: OleVariant;
  //func: TJFunction;
  arglist: PVariantArgList;
  ary: TJArrayObject;
  i,index: Integer;
begin
  if HasDefaultProperty(S) then
  begin
    inherited ;
    Exit;
  end;

  if FHash.HasKey(S) then
    di := FHash[S]
  else begin
    ws := S;
    try
      OLECheck(FDispatch.GetIDsOfNames(
        GUID_NULL,@ws,1,GetUserDefaultLCID,@di));
    except
      raise EJThrow.Create(E_ACTIVEX,S);
    end;
    //LbV
    FHash[S] := di;
  end;

  //
  arglist := nil;
  diput := DISPID_PROPERTYPUT;    
  param.rgvarg := nil;
  param.cArgs := 0;
  param.rgdispidNamedArgs := @diput;
  param.cNamedArgs := 1;

  if IsObject(@Value) and (Value.vObject is TJArrayObject) then
  begin
    //z^̏ꍇ
    ary := Value.vObject as TJArrayObject;
    if ary.Items.Count > 0 then
    begin
      GetMem(arglist,SizeOf(TVariantArg) * ary.Items.Count);
      //tɕϊ
      index := 0;
      for i := ary.Items.Count - 1 downto 0 do
      begin
        //tagVariantOleVariant͓
        arglist^[index] := TVariantArg(ValueToVariant(ary.Items[i]));
        Inc(Index);
      end;

      param.rgvarg := arglist;
      param.cArgs := ary.Items.Count;
    end;
  end
  else begin
    v := ValueToVariant(Value);
    param.rgvarg := @v;
    param.cArgs := 1;
  end;

  //propertyĂяo
  try try
    OLECheck(FDispatch.Invoke(
      di,GUID_NULL,GetUserDefaultLCID,
      DISPATCH_PROPERTYPUT,param,nil,nil,nil));
  except
    raise EJThrow.Create(E_ACTIVEX,S);
  end;

  finally
    if Assigned(arglist) then
      FreeMem(arglist);
  end;
end;

end.
