unit DMonkey;

{
  DMS(DMonkey Script)
  by Wolfy
  License: BSD
           ̃Cu͖ۏ؂łB
           gpAρAzzɈ؂̐͂܂B
           ҂ɒʒm⃉CZX\Kv܂B
  Histroy:
  2002/05/20 ver.0.1.6
          HtmlParser
          RegExp.test()̏C
          ̑

  2002/05/15 ver.0.1.5
          DatȅC

  2002/05/11 ver.0.1.4
          XNvg̑Sp󔒂𖳎悤ɏC
          RegIni
          DatȅC

  2002/04/23 Ver.0.1.3
          Object̂QC

  2002/04/14 Ver.0.1.2
          TJObjectFactory̎dlύXidvjɂTJObject̓RXgN^TJObjectFactoryɎIɏL܂BNewObject\bh͎gpȂłB
          vpeBFactoryǉ
          QƃJEg̏CiUSE_GCKvj
          CheckListBox
  2002/03/21 Ver.0.1.1
          DynaCall̏C
  2002/03/20 Ver.0.1.0
          Cxg̓o^ύX
          DynaCallIuWFNg
  2002/03/10 Ver.0.0.15
          Datě0`11ɕύX
          ArrayIuWFNg̏
          OnStepCxgǉ(XNvg̒fȂǂɎgp)
          K\Cu̕ύX
          String.toUTF8()ǉ
          String.fromUTF8toSJIS()ǉ
  2002/03/06 Ver.0.0.14
          Objecto̎QƃJEgC
          z񎮂̏C
          ArrayIuWFNg̏C
  2002/02/07 Ver.0.0.13
          oC
  2002/02/06 Ver.0.0.12
          IDispatcȟĂяoC
  2002/02/02 Ver.0.0.11
          ClipboardIuWFNg
  2002/02/01 Ver.0.0.10
          ActiveX\bhƃvpeBĂяoC
  2002/01/28 Ver.0.0.9
            KeyboardMouseIuWFNg
  2002/01/27 Ver.0.0.8
            oOC
  2001/11/16 Ver.0.0.7
            G[o
          published property̕P[X𖳎
  2001/05/09 Ver.0.0.6
            var
  2001/05/06 Ver.0.0.5
            import
  2001/05/04 Ver.0.0.4
            NX`
  2001/05/04 Ver.0.0.3
            ActiveXObject
  2001/05/02 Ver.0.0.2
          breakcontinueC
  2001/04/30 Ver.0.0.1
          
}



interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ecma_lex,ecma_parser,ecma_type,ecma_engine,ecma_extobject,ecma_sockobject,
  ecma_activex,ecma_object,ecma_dynacall,ecma_guiobject;

type
  TDMonkey = class(TComponent)
  private
    FRoot: PJStatement;
    FParser: TJParser;
    FEngine: TJEngine;

    FFilename: String;
    FErrorText: String;
    //Cxg
    FOnStdout: TStringEvent;
    FOnDebugout: TStringEvent;
    FOnNewObject: TNewObjectEvent;
    FOnStderr: TStringEvent;
    FOnRun: TNotifyEvent;
    FOnDone: TNotifyEvent;
    FOnStep: TStepEvent;
    //
    procedure ParserOnDebug(Sender: TObject; S: String);
    procedure EngineOnStdout(Sender: TObject; S: String);
    procedure EngineOnStderr(Sender: TObject; S: String);
    procedure EngineOnNewObject(Sender: TObject; JObject: TJObject);
    procedure EngineOnRun(Sender: TObject);
    procedure EngineOnDone(Sender: TObject);
    procedure EngineOnStep(Sender: TObject; var AbortScript: Boolean);

    function GetLibraryPath: TStrings;
    procedure SetLibraryPath(const Value: TStrings);
    function GetObjectCount: Integer;
    function GetGarbageCollection: Boolean;
    procedure SetGarbageCollection(const Value: Boolean);
    procedure SetOnDone(const Value: TNotifyEvent);
    procedure SetOnNewObject(const Value: TNewObjectEvent);
    procedure SetOnRun(const Value: TNotifyEvent);
    procedure SetOnStderr(const Value: TStringEvent);
    procedure SetOnStep(const Value: TStepEvent);
    procedure SetOnStdout(const Value: TStringEvent);
    function GetFactory: TJObjectFactory;
  protected
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function Compile(SourceCode: String): Boolean;
    function CompileFile(AFilename: String): Boolean;
    function Run(Args: array of const; ARoot: PJStatement = nil): Integer; overload;
    function Run(Args: TJValueList; ARoot: PJStatement = nil): Integer; overload;
    function Run(ARoot: PJStatement = nil): Integer; overload;
    function CallFunction(Symbol: String; Param: array of const; var RetValue: TJValue): Boolean; overload;
    function CallFunction(Symbol: String; Param: TJValueList; var RetValue: TJValue): Boolean; overload;
    procedure Clear;
    procedure Abort;
    procedure ImportObject(ObjectName: String; ObjectClass: TJObjectClass);
    function IsRunning: Boolean;

    property ObjectCount: Integer read GetObjectCount;
    property Factory: TJObjectFactory read GetFactory;
  published
    property LibraryPath: TStrings read GetLibraryPath write SetLibraryPath;
    property GarbageCollection: Boolean read GetGarbageCollection write SetGarbageCollection;
    //Cxg
    property OnStdout: TStringEvent read FOnStdout write SetOnStdout;
    property OnStderr: TStringEvent read FOnStderr write SetOnStderr;
    property OnDebugout: TStringEvent read FOnDebugout write FOnDebugout;
    property OnNewObject: TNewObjectEvent read FOnNewObject write SetOnNewObject;
    property OnRun: TNotifyEvent read FOnRun write SetOnRun;
    property OnDone: TNotifyEvent read FOnDone write SetOnDone;
    property OnStep: TStepEvent read FOnStep write SetOnStep;
  end;

  TDMS = class(TDMonkey);
  

procedure ShowDMonkeyException(DMonkey: TDMonkey);


procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TDMS]);
end;


procedure ShowDMonkeyException(DMonkey: TDMonkey);
//G[\
var
  caption,text: String;
begin
  caption := 'DMS';
  if DMonkey.FFilename <> '' then
    caption := caption + '(' + ExtractFilename(DMonkey.FFilename) + ')';

  text := DMonkey.FErrorText;
  Application.MessageBox(PChar(text),PChar(caption),MB_OK);
end;


{ TDMonkey }

procedure TDMonkey.Abort;
//~
begin
  FEngine.Abort;
end;

function TDMonkey.CallFunction(Symbol: String; Param: TJValueList; var RetValue: TJValue): Boolean;
//֐Ăяo
begin
  Result := False;
  if Assigned(FRoot) then
  begin
    if Assigned(Param) then
      Result := FEngine.CallFunction(FRoot,Symbol,Param,RetValue)
    else begin
      Param := TJValueList.Create;
      try
        Result := FEngine.CallFunction(FRoot,Symbol,Param,RetValue);
      finally
        Param.Free;
      end;
    end;
  end;
end;

function TDMonkey.CallFunction(Symbol: String;
  Param: array of const; var RetValue: TJValue): Boolean;
//֐Ăяo
var
  list: TJValueList;
  i: Integer;
begin
  Result := False;
  if Assigned(FRoot) then
  begin
    list := TJValueList.Create;
    try
      //ϊ
      for i := 0 to High(Param) do
        list.Add(VarRecToValue(Param[i]));

      Result := CallFunction(Symbol,list,RetValue);
    finally
      list.Free;
    end;
  end;
end;

procedure TDMonkey.Clear;
//f[^NA
begin
  FRoot := nil;
  FParser.Clear;
  FEngine.AllClear;
end;

function TDMonkey.Compile(SourceCode: String): Boolean;
//͖؂
begin
  Result := False;
  FParser.Clear;
  //fobO
  if Assigned(FOnDebugout) then
    FParser.Lex.OnDebug := ParserOnDebug;

  FParser.SourceCode := SourceCode;
  try
    Result := FParser.Parse;
    if Result then
      FRoot := FParser.Root
    else
      FRoot := nil;
  except
    on E:EJSyntaxError do
      EngineOnStderr(Self,(E.Message));
    on E:EJThrow do
      EngineOnStderr(Self,'Exception: ' + E.Message + ' => ' + E.ErrorMsg);
  end;
end;

function TDMonkey.CompileFile(AFilename: String): Boolean;
//t@Cw肵Ďs
var
  sl: TStringList;
begin
  Result := False;
  FFilename := AFilename;
  if not FileExists(AFilename) then
    Exit;

  sl := TStringList.Create;
  try
    sl.LoadFromFile(AFilename);
    Result := Compile(sl.Text);
  finally
    sl.Free;
  end;
end;

constructor TDMonkey.Create(AOwner: TComponent);
//쐬
begin
  inherited;
  FParser := TJParser.Create;
  FEngine := TJEngine.Create;
  //FEngine.OnStderr := EngineOnStderr;
  //FEngine.OnStdout := EngineOnStdout;
  //FEngine.OnNewObject := EngineOnNewObject;
  //FEngine.OnRun := EngineOnRun;
  //FEngine.OnDone := EngineOnDone;
  //FEngine.OnStep := EngineOnStep;

  //gobjectC|[g
  ImportObject('File',TJFileObject);
  ImportObject('Directory',TJDirectoryObject);
  ImportObject('Strings',TJStringsObject);
  ImportObject('Win32',TJWin32Object);
  ImportObject('Ini',TJIniObject);
  ImportObject('CRC',TJCRCObject);
  ImportObject('Base64',TJBase64Object);
  ImportObject('Dialog',TJDialogObject);
  ImportObject('URL',TJUrlInfoObject);
  ImportObject('Cookie',TJCookieObject);
  ImportObject('Response',TJResponseObject);
  ImportObject('HTTP',TJHTTPObject);
  ImportObject('HTTPS',TJHTTPSObject);
  ImportObject('TCPSocket',TJTCPSocketObject);
  ImportObject('Mail',TJMailObject);
  ImportObject('POP3',TJPOP3Object);
  ImportObject('SMTP',TJSMTPObject);
  ImportObject('Mutex',TJMutexObject);
  ImportObject('ActiveXObject',TJActiveXObject);
  ImportObject('Keyboard',TJKeyboard);
  ImportObject('Mouse',TJMouse);
  ImportObject('Clipboard',TJClipboard);
  ImportObject('DynaCall',TJDynaCall);
  ImportObject('CheckListBox',TJCheckListBox);
  ImportObject('RegIni',TJRegIniObject);
  ImportObject('HtmlTag',TJHtmlTagObject);
  ImportObject('HtmlParser',TJHtmlParserObject);
end;

destructor TDMonkey.Destroy;
//j
begin
  Clear;   
  FreeAndNil(FParser);
  FreeAndNil(FEngine);
  inherited;
end;

procedure TDMonkey.EngineOnDone(Sender: TObject);
begin
 if Assigned(FOnDone) then
   FOnDone(Self);
end;

procedure TDMonkey.EngineOnNewObject(Sender: TObject; JObject: TJObject);
//object 쐬Cxg
begin
  if Assigned(FOnNewObject) then
    FOnNewObject(Self,JObject);
end;

procedure TDMonkey.EngineOnRun(Sender: TObject);
begin
  if Assigned(FOnRun) then
    FOnRun(Self);
end;

procedure TDMonkey.EngineOnStderr(Sender: TObject; S: String);
//WG[
begin
  FErrorText := S;
  if Assigned(FOnStderr) then
    FOnStderr(Self,S);
end;

procedure TDMonkey.EngineOnStdout(Sender: TObject; S: String);
//Wo
begin
  if Assigned(FOnStdout) then
    FOnStdout(Self,S);
end;

procedure TDMonkey.EngineOnStep(Sender: TObject; var AbortScript: Boolean);
begin
  if Assigned(FOnStep) then
    FOnStep(Self,AbortScript);
end;

function TDMonkey.GetGarbageCollection: Boolean;
begin
  Result := FEngine.GarbageCollection;
end;

function TDMonkey.GetLibraryPath: TStrings;
begin
  Result := FParser.LibPath;
end;

function TDMonkey.GetObjectCount: Integer;
begin
  Result := FEngine.ObjectCount;
end;

procedure TDMonkey.ImportObject(ObjectName: String;
  ObjectClass: TJObjectClass);
//g݃IuWFNgC|[g
begin
  FEngine.ImportObject(ObjectName,ObjectClass);
end;

function TDMonkey.IsRunning: Boolean;
begin
  Result := FEngine.IsRunning;
end;

procedure TDMonkey.ParserOnDebug(Sender: TObject; S: String);
//fobO
begin
  if Assigned(FOnDebugout) then
    FOnDebugout(Self,S);
end;

function TDMonkey.Run(Args: array of const; ARoot: PJStatement): Integer;
//scripts
var
  i: Integer;
  rt: PJStatement;
begin
  Result := 0;
  //argmuments valueo^
  FEngine.GlobalObject.Arguments.Clear;
  //rootI
  if Assigned(ARoot) then
    rt := ARoot
  else
    rt := FRoot;

  if Assigned(rt) then
  begin
    //ϊ
    for i := 0 to High(Args) do
      FEngine.GlobalObject.arguments.Add(VarRecToValue(Args[i]));

    Result := FEngine.Run(rt);
  end;
end;

function TDMonkey.Run(Args: TJValueList; ARoot: PJStatement): Integer;
//s
var
  i: Integer;
  rt: PJStatement;
begin
  Result := 0;
  FEngine.GlobalObject.Arguments.Clear;
  //rootI
  if Assigned(ARoot) then
    rt := ARoot
  else
    rt := FRoot;

  if Assigned(rt) then
  begin
    if Assigned(Args) then
    begin
      for i := 0 to Args.Count - 1 do
        FEngine.GlobalObject.Arguments.Add(Args[i]);
    end;

    Result := FEngine.Run(rt);
  end;
end;

function TDMonkey.Run(ARoot: PJStatement): Integer;
//s
begin
  Result := Run([],ARoot);
end;

procedure TDMonkey.SetGarbageCollection(const Value: Boolean);
begin
  FEngine.GarbageCollection := Value;
end;

procedure TDMonkey.SetLibraryPath(const Value: TStrings);
begin
  FParser.LibPath.Assign(Value);
end;

procedure TDMonkey.SetOnDone(const Value: TNotifyEvent);
begin
  FOnDone := Value;
  if Assigned(Value) then
    FEngine.OnDone := EngineOnDone
  else
    FEngine.OnDone := nil;
end;

procedure TDMonkey.SetOnNewObject(const Value: TNewObjectEvent);
begin
  FOnNewObject := Value;
  if Assigned(Value) then
    FEngine.OnNewObject := EngineOnNewObject
  else
    FEngine.OnNewObject := nil;
end;

procedure TDMonkey.SetOnRun(const Value: TNotifyEvent);
begin
  FOnRun := Value;
  if Assigned(Value) then
    FEngine.OnRun := EngineOnRun
  else
    FEngine.OnRun := nil;
end;

procedure TDMonkey.SetOnStderr(const Value: TStringEvent);
begin
  FOnStderr := Value;
  if Assigned(Value) then
    FEngine.OnStdErr := EngineOnStdErr
  else
    FEngine.OnStdErr := nil;
end;

procedure TDMonkey.SetOnStep(const Value: TStepEvent);
begin
  FOnStep := Value;
  if Assigned(Value) then
    FEngine.OnStep := EngineOnStep
  else
    FEngine.OnStep := nil;
end;

procedure TDMonkey.SetOnStdout(const Value: TStringEvent);
begin
  FOnStdout := Value;
  if Assigned(Value) then
    FEngine.OnStdOut := EngineOnStdOut
  else
    FEngine.OnStdOut := nil;
end;

function TDMonkey.GetFactory: TJObjectFactory;
begin
  Result := FEngine.GlobalFactory;
end;

end.
