/*
 * Decompiled with CFR 0.152.
 */
package jp.osdn.dddsupport.basegenerator.model;

import jp.osdn.dddsupport.basegenerator.model.ClassName;
import jp.osdn.dddsupport.basegenerator.model.Field;
import jp.osdn.dddsupport.basegenerator.model.ImportClass;
import jp.osdn.dddsupport.basegenerator.model.ImportClasses;
import jp.osdn.dddsupport.basegenerator.model.PackageName;

public class JavaSourceBuilder {
    private StringBuilder builder = new StringBuilder();
    private static final String LINE_END = ";";
    private static final String LINE_FEED = System.lineSeparator();

    public JavaSourceBuilder(PackageName packageName) {
        if (!packageName.isDefaultPackage()) {
            this.builder.append("package ");
            this.builder.append(packageName);
            this.builder.append(LINE_END).append(LINE_FEED).append(LINE_FEED);
        }
    }

    public JavaSourceBuilder includes(ImportClasses packages) {
        for (ImportClass ic : packages.getImportClasses()) {
            this.builder.append("import ").append(ic).append(LINE_END).append(LINE_FEED);
        }
        this.builder.append(LINE_FEED);
        return this;
    }

    public JavaSourceBuilder className(ClassName className) {
        this.builder.append("public class ");
        this.builder.append(className);
        this.builder.append(" {");
        this.builder.append(LINE_FEED);
        return this;
    }

    public JavaSourceBuilder interfaceName(ClassName interfaceName) {
        this.builder.append("public interface ");
        this.builder.append(interfaceName);
        this.builder.append(" {");
        this.builder.append(LINE_FEED);
        return this;
    }

    public JavaSourceBuilder enumName(ClassName enumName) {
        this.builder.append("public enum ");
        this.builder.append(enumName);
        this.builder.append(" {");
        this.builder.append(LINE_FEED);
        return this;
    }

    public JavaSourceBuilder field(Field field) {
        this.builder.append("private ").append(field);
        this.builder.append(LINE_END).append(LINE_FEED);
        return this;
    }

    public String build() {
        this.builder.append("}");
        return this.builder.toString();
    }
}

