/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.bookmark.BookmarkManager;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.views.Messages;

public class TreeContentProvider
implements ITreeContentProvider {
    private BookmarkManager bookMarkMgr = DbPlugin.getDefault().getBookmarkManager();
    private Root invisibleRoot;
    private Root root;
    private BookmarkRoot bookmarkRoot;
    private IDBConfig[] dbConfigs;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        if (this.invisibleRoot == null) {
            this.initialize();
        }
        return this.getChildren(this.invisibleRoot);
    }

    public Object getParent(Object element) {
        if (element instanceof TreeLeaf) {
            return ((TreeLeaf)element).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeNode) {
            return ((TreeNode)parentElement).getChildrens();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }

    public void initialize() {
        this.invisibleRoot = new Root("invisible", true);
        this.root = new Root("DBViewerPlugin");
        this.invisibleRoot.addChild(this.root);
        try {
            this.bookmarkRoot = this.bookMarkMgr.getBookmarkRoot();
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
        if (this.bookmarkRoot == null || this.bookmarkRoot.getName() == null) {
            this.bookmarkRoot = new BookmarkRoot(Messages.getString("TreeContentProvider.2"));
        }
        this.bookMarkMgr.setBookmarkRoot(this.bookmarkRoot);
        this.invisibleRoot.addChild(this.bookmarkRoot);
        this.createDataBase();
    }

    public void createDataBase() {
        this.dbConfigs = DBConfigManager.getDBConfigs();
        int i = 0;
        while (i < this.dbConfigs.length) {
            IDBConfig config = this.dbConfigs[i];
            DataBase db = new DataBase(config);
            this.root.addChild(db);
            ++i;
        }
    }

    public DataBase addDataBase(IDBConfig config) {
        DataBase db = new DataBase(config);
        this.root.addChild(db);
        return db;
    }

    public BookmarkRoot getBookmarkRoot() {
        return this.bookmarkRoot;
    }

    public void setBookmarkRoot(BookmarkRoot bookmarkRoot) {
        this.bookmarkRoot = bookmarkRoot;
    }

    public DataBase findDataBase(Bookmark bookmark) {
        TreeLeaf[] leafs = this.root.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            DataBase db;
            TreeLeaf leaf = leafs[i];
            if (leaf instanceof DataBase && (db = (DataBase)leaf).getName().equals(bookmark.getDataBase().getName())) {
                return db;
            }
            ++i;
        }
        return null;
    }

    public Root getRoot() {
        return this.root;
    }

    public DataBase[] getDataBases() {
        TreeLeaf[] leafs = this.root.getChildrens();
        ArrayList<TreeLeaf> list = new ArrayList<TreeLeaf>();
        int i = 0;
        while (i < leafs.length) {
            TreeLeaf leaf = leafs[i];
            if (leaf instanceof DataBase) {
                list.add(leaf);
            }
            ++i;
        }
        return list.toArray(new DataBase[0]);
    }

    public DataBase findDataBase(IDBConfig config) {
        TreeLeaf[] leafs = this.root.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            DataBase db;
            TreeLeaf leaf = leafs[i];
            if (leaf instanceof DataBase && (db = (DataBase)leaf).getName().equals(config.getDbName())) {
                return db;
            }
            ++i;
        }
        return null;
    }

    public IDBConfig[] getDBConfigs() {
        return this.dbConfigs;
    }
}

