/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.sql.Connection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.TableInfo;
import zigen.plugin.db.core.TableSearcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.OracleSequence;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.views.TableSearchThread;

public class TableTypeSearchAction
implements Runnable {
    TreeViewer viewer;
    Schema schema;

    public TableTypeSearchAction(TreeViewer viewer, Schema schema) {
        this.viewer = viewer;
        this.schema = schema;
    }

    public void run() {
        try {
            Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
            if (element instanceof Schema) {
                Schema schema = (Schema)element;
                Connection con = Transaction.getInstance(schema.getDbConfig()).getConnection();
                String[] tableTypes = schema.getDataBase().getTableType();
                int i = 0;
                while (i < tableTypes.length) {
                    String[] types = new String[]{tableTypes[i]};
                    if ("SEQUENCE".equals(tableTypes[i])) {
                        switch (DBType.getType(schema.getDbConfig())) {
                            case 1: {
                                Folder folder = new Folder();
                                folder.setName(tableTypes[i]);
                                OracleSequence seq = new OracleSequence();
                                seq.setName(DbPluginConstant.TREE_LEAF_LOADING);
                                folder.addChild(seq);
                                schema.addChild(folder);
                            }
                        }
                    } else {
                        TableInfo[] tables = TableSearcher.execute(con, schema.getName(), types);
                        TableSearchThread.addFolderAndTables(con, schema, tableTypes[i], tables);
                    }
                    ++i;
                }
                schema.setExpanded(true);
                this.viewer.refresh((Object)schema);
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

