/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.QualifiedName;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBConfigManager;
import zigen.plugin.db.core.IDBConfig;

public class FileUtil {
    public static IDBConfig getDBConfig(IFile file) {
        String dbName = FileUtil.getDBConfigName(file);
        if (dbName != null) {
            return DBConfigManager.getDBConfig(dbName);
        }
        return null;
    }

    static String getDBConfigName(IFile file) {
        String dbName = null;
        try {
            if (file.isAccessible()) {
                dbName = file.getPersistentProperty(new QualifiedName("zigen.plugin.db", "SELECTED_DB"));
            }
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
        return dbName;
    }

    /*
     * Loose catch block
     */
    public static String getContents(IFile file) {
        int len;
        char[] buffer = new char[4096];
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        reader = new BufferedReader(new InputStreamReader(file.getContents()));
        while ((len = reader.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, len));
        }
        String string = sb.toString();
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception e) {
            try {
                DbPlugin.getDefault().showErrorDialog(e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static boolean isSqlFile(IFile file) {
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".sql");
    }

    /*
     * Loose catch block
     */
    public static String getContents(File file) {
        int len;
        char[] buffer = new char[4096];
        BufferedReader reader = null;
        StringBuffer sb = new StringBuffer();
        reader = new BufferedReader(new FileReader(file));
        while ((len = reader.read(buffer)) != -1) {
            sb.append(new String(buffer, 0, len));
        }
        String string = sb.toString();
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (Exception e) {
            try {
                DbPlugin.getDefault().showErrorDialog(e);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static boolean isSqlFile(File file) {
        String fileName = file.getName().toLowerCase();
        return fileName.endsWith(".sql");
    }

    public static boolean rename(File file) {
        String folder = file.getParent();
        String fileName = file.getName();
        SimpleDateFormat format = new SimpleDateFormat("yyyy_MM_dd");
        String date = format.format(Calendar.getInstance().getTime());
        String suffix = "." + date + "_bak";
        return file.renameTo(new File(String.valueOf(folder) + File.separator + fileName + suffix));
    }
}

