/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.popup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.jobs.SqlExecJob;
import zigen.plugin.db.ui.popup.Messages;
import zigen.plugin.db.ui.util.FileUtil;
import zigen.plugin.db.ui.util.ResourceUtil;

public class ExecSQLFileAction
extends Action
implements IObjectActionDelegate {
    protected IFile file;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        try {
            if (this.file != null) {
                IDBConfig config = ResourceUtil.getDBConfig((IResource)this.file);
                if (config != null) {
                    String sql = FileUtil.getContents(this.file);
                    if (sql != null && sql.trim().length() > 0) {
                        Transaction trans = Transaction.getInstance(config);
                        SqlExecJob job = new SqlExecJob(trans, sql, null);
                        job.setUser(false);
                        job.schedule();
                    } else {
                        DbPlugin.getDefault().showInformationMessage(Messages.getString("ExecSQLFileAction.0"));
                    }
                } else {
                    DbPlugin.getDefault().showInformationMessage(Messages.getString("ExecSQLFileAction.1"));
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        StructuredSelection ss;
        Object obj;
        action.setEnabled(false);
        if (selection instanceof StructuredSelection && (obj = (ss = (StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            IFile wkfile;
            this.file = wkfile = (IFile)obj;
            action.setEnabled(true);
        }
    }
}

