/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.OracleSequeceSearchJob;
import zigen.plugin.db.ui.jobs.OracleSourceSearchJob;
import zigen.plugin.db.ui.jobs.RefreshFolderJob;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;

public class RefreshSchemaJob
extends AbstractJob {
    private TreeViewer viewer;
    private Schema schema;

    public RefreshSchemaJob(TreeViewer viewer, Schema schema) {
        super(Messages.getString("RefreshSchemaJob.0"));
        this.viewer = viewer;
        this.schema = schema;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            List folders = this.schema.getChildren();
            monitor.beginTask(Messages.getString("RefreshSchemaJob.1"), folders.size());
            for (Folder folder : folders) {
                AbstractJob job;
                monitor.subTask(String.valueOf(folder.getName()) + Messages.getString("RefreshSchemaJob.2"));
                folder.setExpanded(true);
                if (this.schema != null) {
                    block2 : switch (DBType.getType(this.schema.getDbConfig())) {
                        case 1: {
                            if (this.schema == null) break;
                            if ("SEQUENCE".equals(folder.getName())) {
                                job = new OracleSequeceSearchJob(this.viewer, folder);
                                job.setPriority(20);
                                job.schedule();
                                break;
                            }
                            String[] sTypes = this.schema.getSourceType();
                            if (sTypes == null) break;
                            int i = 0;
                            while (i < sTypes.length) {
                                String stype = sTypes[i];
                                if (stype.equals(folder.getName())) {
                                    OracleSourceSearchJob job2 = new OracleSourceSearchJob(this.viewer, folder);
                                    job2.setPriority(20);
                                    job2.schedule();
                                    break block2;
                                }
                                ++i;
                            }
                            break;
                        }
                    }
                }
                job = new RefreshFolderJob(this.viewer, folder);
                job.setPriority(20);
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException e) {
                    DbPlugin.log(e);
                }
                monitor.worked(1);
            }
            this.schema.setExpanded(true);
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.schema, 0));
        }
        catch (Exception e) {
            this.schema.setExpanded(false);
            this.showErrorMessage(Messages.getString("RefreshSchemaJob.4"), e);
        }
        return Status.OK_STATUS;
    }
}

