/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.TableViewEditorInput;
import zigen.plugin.db.ui.editors.exceptions.NotFoundSynonymInfoException;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.Messages;
import zigen.plugin.db.ui.jobs.RefreshColumnJob;
import zigen.plugin.db.ui.jobs.RefreshTreeNodeAction;
import zigen.plugin.db.ui.views.SQLExecuteView;

public class OpenEditorJob
extends RefreshColumnJob {
    public static final String JOB_NAME = OpenEditorJob.class.getName();
    private TreeViewer viewer;
    private ITable table;
    private static Object lock = new Object();

    public OpenEditorJob(TreeViewer viewer, ITable table) {
        super(viewer, table);
        super.setName(Messages.getString("OpenEditorJob.0"));
        this.viewer = viewer;
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            Object object = lock;
            synchronized (object) {
                Bookmark bookmark;
                DataBase db;
                IDBConfig config = this.table.getDbConfig();
                Transaction.getInstance(config).getConnection();
                monitor.beginTask("Open Editor...", 10);
                this.showResults(new ShowSQLViewerAction(this.table));
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.showSyncResults(new ShowTableEditorAction(this.table));
                if (this.table instanceof Bookmark && !(db = this.findDataBase(bookmark = (Bookmark)this.table)).isConnected()) {
                    db.setConnected(true);
                    db.removeChild(db.getChild(DbPluginConstant.TREE_LEAF_LOADING));
                    if (db.isSchemaSupport()) {
                        db.addChild(new Schema(DbPluginConstant.TREE_LEAF_LOADING));
                    } else {
                        db.addChild(new Folder(DbPluginConstant.TREE_LEAF_LOADING));
                    }
                    this.showResults(new RefreshTreeNodeAction(this.viewer, db, 2));
                }
                monitor.done();
            }
        }
        catch (NotFoundSynonymInfoException e) {
            this.table.setEnabled(false);
            this.table.removeChildAll();
            this.showResults(new RefreshTreeNodeAction(this.viewer, this.table));
            this.showErrorMessage(Messages.getString("OpenEditorJob.1"), e);
        }
        catch (Exception e) {
            this.showErrorMessage(Messages.getString("OpenEditorJob.2"), e);
        }
        return Status.OK_STATUS;
    }

    protected class ShowSQLViewerAction
    implements Runnable {
        ITable table;

        public ShowSQLViewerAction(ITable table) {
            this.table = table;
        }

        public void run() {
            try {
                IDBConfig config = this.table.getDbConfig();
                if (config != null) {
                    SQLExecuteView view = null;
                    IWorkbenchPage page = DbPlugin.getDefault().getPage();
                    IViewReference[] references = page.getViewReferences();
                    int i = 0;
                    while (i < references.length) {
                        IViewReference reference = references[i];
                        String viewId = reference.getId();
                        String secondaryId = reference.getSecondaryId();
                        if ("zigen.plugin.db.ui.views.SQLExecuteView".equals(viewId) && (view = secondaryId != null ? (SQLExecuteView)reference.getView(true) : (SQLExecuteView)reference.getView(true)) != null) {
                            view.updateCombo(config);
                            break;
                        }
                        ++i;
                    }
                    if (view == null) {
                        view = (SQLExecuteView)DbPlugin.showView("zigen.plugin.db.ui.views.SQLExecuteView");
                        view.updateCombo(config);
                    }
                }
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
        }
    }

    protected class ShowTableEditorAction
    implements Runnable {
        ITable table;

        public ShowTableEditorAction(ITable table) {
            this.table = table;
        }

        public void run() {
            block3: {
                IEditorPart editor = null;
                try {
                    TimeWatcher tw = new TimeWatcher();
                    tw.start();
                    IDBConfig config = this.table.getDbConfig();
                    TableViewEditorInput input = new TableViewEditorInput(config, this.table);
                    IWorkbenchPage page = DbPlugin.getDefault().getPage();
                    editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.ui.editors.TableViewEditor", (boolean)true);
                    if (editor instanceof TableViewEditorFor31) {
                        TableViewEditorFor31 tEditor = (TableViewEditorFor31)editor;
                        tEditor.setSelection(OpenEditorJob.this.viewer.getSelection());
                        boolean isSearch = false;
                        tEditor.createResultPage(config, this.table, isSearch);
                    }
                    tw.stop();
                }
                catch (Exception e) {
                    DbPlugin.getDefault().showErrorDialog(e);
                    if (editor == null) break block3;
                    editor.dispose();
                }
            }
        }
    }
}

