/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.ChangeColorRecordDefine;
import zigen.plugin.db.ui.views.internal.ColorManager;

public class ChangeColorJobDefine
extends AbstractJob {
    protected IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
    protected Table table;
    protected ITable tableNode;
    protected int columnSize;
    protected int rowSize;
    protected Color blue;
    protected Color black;
    protected Color glay;
    protected Color white;
    protected Color lightblue;
    protected Column selectedColumn;

    public ChangeColorJobDefine(Table targetTable) {
        this(targetTable, null);
    }

    public ChangeColorJobDefine(Table targetTable, ITable targetTableNode) {
        super("Changing ForgoundColor...");
        this.table = targetTable;
        this.tableNode = targetTableNode;
        this.columnSize = this.table.getColumnCount();
        this.rowSize = this.table.getItemCount();
        ColorManager colorManager = new ColorManager();
        Display display = Display.getDefault();
        this.blue = new Color((Device)display, 0, 0, 255);
        this.black = new Color((Device)display, 0, 0, 0);
        this.glay = display.getSystemColor(22);
        this.white = display.getSystemColor(1);
        this.lightblue = colorManager.getColor("PreferencePage.BackGround");
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.store.getBoolean("PreferencePage.ChangeNullColor")) {
                String nullSymbol = DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
                int i = 0;
                while (i < this.rowSize) {
                    ChangeColorRecordDefine thread = this.tableNode != null ? new ChangeColorRecordDefine(this.table, i, this.columnSize, this.tableNode) : new ChangeColorRecordDefine(this.table, i, this.columnSize);
                    thread.setNullSymbol(nullSymbol);
                    thread.setBlack(this.black);
                    thread.setBlue(this.blue);
                    thread.setGlay(this.glay);
                    thread.setWhite(this.white);
                    thread.setLightblue(this.lightblue);
                    thread.setSelectedColumn(this.selectedColumn);
                    this.showResults(thread);
                    ++i;
                }
            }
        }
        catch (SWTException e) {
            DbPlugin.log(e);
        }
        catch (Exception e) {
            this.showErrorMessage("", e);
        }
        return Status.OK_STATUS;
    }

    public void setSelectedColumn(Column selectedColumn) {
        this.selectedColumn = selectedColumn;
    }
}

