/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import java.util.ArrayList;
import java.util.List;
import zigen.plugin.db.ui.internal.TreeLeaf;

public class TreeNode
extends TreeLeaf {
    private static final long serialVersionUID = 1L;
    protected List children = new ArrayList();
    protected boolean isRoot;
    protected boolean isExpanded = false;

    public TreeNode() {
        this(null, false);
    }

    public TreeNode(String name) {
        this(name, false);
    }

    public TreeNode(String name, boolean isRoot) {
        super(name);
        this.isRoot = isRoot;
    }

    public void addChild(TreeLeaf child) {
        this.children.add(child);
        child.setParent(this);
        child.setLevel(this.level + 1);
    }

    public void removeChild(TreeLeaf child) {
        this.children.remove(child);
        if (child != null) {
            child.setParent(null);
        }
    }

    public void removeChildAll() {
        TreeLeaf[] elements = this.getChildrens();
        int i = 0;
        while (i < elements.length) {
            TreeLeaf elem = elements[i];
            this.removeChild(elem);
            ++i;
        }
    }

    public TreeLeaf[] getChildrens() {
        return this.children.toArray(new TreeLeaf[this.children.size()]);
    }

    public TreeLeaf getChild(String name) {
        TreeLeaf[] elements = this.getChildrens();
        int i = 0;
        while (i < elements.length) {
            TreeLeaf elem = elements[i];
            if (elem.getName().equals(name)) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public void setChildren(List children) {
        this.children = children;
        for (TreeNode node : children) {
            node.setParent(this);
            node.setLevel(this.level + 1);
        }
    }

    public List getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        TreeNode castedObj = (TreeNode)o;
        return (this.children == null ? castedObj.children == null : this.children.equals(castedObj.children)) && this.isRoot == castedObj.isRoot;
    }
}

