/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import java.util.ArrayList;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class Schema
extends TreeNode {
    private static final long serialVersionUID = 1L;
    private String[] sourceTypes;

    public Schema() {
    }

    public Schema(String name) {
        super(name);
    }

    public void update(Schema node) {
        this.sourceTypes = node.sourceTypes;
    }

    private Schema getNewSchema(Schema schema) {
        String schemaName = schema.getName();
        DataBase db = schema.getDataBase();
        TreeLeaf[] leafs = db.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            Schema newSchema;
            if (leafs[i] instanceof Schema && schemaName.equals((newSchema = (Schema)leafs[i]).getName())) {
                return newSchema;
            }
            ++i;
        }
        return null;
    }

    private Table[] convertTables(TreeLeaf[] leafs) {
        ArrayList<Table> list = new ArrayList<Table>(leafs.length);
        int i = 0;
        while (i < leafs.length) {
            if (leafs[i] instanceof Table) {
                list.add((Table)leafs[i]);
            }
            ++i;
        }
        return list.toArray(new Table[0]);
    }

    public Table[] getTables() {
        TreeLeaf[] leafs = this.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            Folder folder;
            if (leafs[i] instanceof Folder && "TABLE".equals((folder = (Folder)leafs[i]).getName())) {
                return this.convertTables(folder.getChildrens());
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Schema castedObj = (Schema)o;
        IDBConfig config = castedObj.getDbConfig();
        if (config == null) {
            System.err.println("Schema#equals() DBConfig\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002");
            return false;
        }
        return castedObj.getName().equals(this.getName()) && config.equals(this.getDbConfig());
    }

    public Object clone() {
        Schema inst = new Schema();
        inst.name = this.name == null ? null : new String(this.name);
        return inst;
    }

    public String[] getSourceType() {
        return this.sourceTypes;
    }

    public void setSourceType(String[] sourceTypes) {
        this.sourceTypes = sourceTypes;
    }
}

