/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.internal;

import java.sql.Connection;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SchemaSearcher;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class ContentAssistTable
extends TreeNode
implements ITable {
    private static final long serialVersionUID = 1L;
    protected IDBConfig dbConfig;
    protected DataBase dataBase;
    protected Schema schema;
    protected ITable table;
    protected Folder folder;
    boolean isEnabled = true;

    public ContentAssistTable(IDBConfig dbConfig, String schemaName, String tableName) {
        super(tableName);
        this.dbConfig = dbConfig;
        this.dataBase = new DataBase(dbConfig);
        this.setSchemaSupport(this.dataBase);
        if (this.dataBase.isSchemaSupport()) {
            this.schema = new Schema(schemaName);
        }
        this.table = new Table(tableName);
    }

    public ContentAssistTable(Table table) {
        this.copy(table);
    }

    private void setSchemaSupport(DataBase dataBase) {
        try {
            Connection con = Transaction.getInstance(this.dbConfig).getConnection();
            boolean b = SchemaSearcher.isSupport(con);
            this.dataBase.setSchemaSupport(b);
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    public void copy(Table original) {
        this.name = new String(original.getName());
        this.dataBase = (DataBase)original.getDataBase().clone();
        this.dbConfig = this.dataBase.getDbConfig();
        if (original.getSchema() != null) {
            this.schema = (Schema)original.getSchema().clone();
        }
        this.table = (Table)original.clone();
        this.folder = (Folder)original.getFolder().clone();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private Column[] convertColumns(TreeLeaf[] leafs) {
        ArrayList<Column> list = new ArrayList<Column>(leafs.length);
        int i = 0;
        while (i < leafs.length) {
            if (leafs[i] instanceof Column) {
                list.add((Column)leafs[i]);
            }
            ++i;
        }
        return list.toArray(new Column[0]);
    }

    public Column[] getColumns() {
        return this.convertColumns(this.getChildrens());
    }

    public String getLabel() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (this.table.getRemarks() != null && this.table.getRemarks().length() > 0) {
            sb.append(" [");
            sb.append(this.table.getRemarks());
            sb.append("]");
        }
        return sb.toString();
    }

    public String getRemarks() {
        return this.table.getRemarks();
    }

    public String getSchemaName() {
        if (this.schema != null) {
            return this.schema.getName();
        }
        return null;
    }

    public String getSqlTableName() {
        StringBuffer sb = new StringBuffer();
        if (this.dataBase.isSchemaSupport()) {
            if (StringUtil.isNumeric(this.schema.getName())) {
                sb.append("\"");
                sb.append(this.schema.getName());
                sb.append("\"");
                sb.append(".");
                sb.append(this.name);
            } else {
                sb.append(String.valueOf(this.schema.getName()) + "." + this.name);
            }
        } else {
            sb.append(this.name);
        }
        return sb.toString();
    }

    public boolean isSchemaSupport() {
        return this.dataBase.isSchemaSupport();
    }

    public ITable getTable() {
        return this.table;
    }

    public void setTable(ITable table) {
        this.table = table;
    }

    public DataBase getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(DataBase dataBase) {
        this.dataBase = dataBase;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public IDBConfig getDbConfig() {
        return this.dbConfig;
    }

    public void setDbConfig(IDBConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    public TableFKColumn[] getTableFKColumns() {
        if (this.table != null) {
            return this.table.getTableFKColumns();
        }
        return null;
    }

    public TablePKColumn[] getTablePKColumns() {
        if (this.table != null) {
            return this.table.getTablePKColumns();
        }
        return null;
    }

    public TableIDXColumn[] getTableUIDXColumns() {
        if (this.table != null) {
            return this.table.getTableUIDXColumns();
        }
        return null;
    }

    public TableIDXColumn[] getTableNonUIDXColumns() {
        if (this.table != null) {
            return this.table.getTableNonUIDXColumns();
        }
        return null;
    }

    public void setTableFKColumns(TableFKColumn[] tableFKColumns) {
        this.table.setTableFKColumns(tableFKColumns);
    }

    public void setTablePKColumns(TablePKColumn[] tablePKColumns) {
        this.table.setTablePKColumns(tablePKColumns);
    }

    public void setTableUIDXColumns(TableIDXColumn[] tableUIDXColumns) {
        this.table.setTableUIDXColumns(tableUIDXColumns);
    }

    public void setTableNonUIDXColumns(TableIDXColumn[] tableNonUIDXColumns) {
        this.table.setTableNonUIDXColumns(tableNonUIDXColumns);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[ContentsAssistTable:");
        buffer.append(" children: ");
        buffer.append(this.children);
        buffer.append(" isRoot: ");
        buffer.append(this.isRoot);
        buffer.append(" isExpanded: ");
        buffer.append(this.isExpanded);
        buffer.append(" name: ");
        buffer.append(this.name);
        buffer.append(" parent: ");
        buffer.append(this.parent);
        buffer.append(" dbConfig: ");
        buffer.append(this.dbConfig);
        buffer.append(" dataBase: ");
        buffer.append(this.dataBase);
        buffer.append(" schema: ");
        buffer.append(this.schema);
        buffer.append(" folder: ");
        buffer.append(this.folder);
        buffer.append(" table: ");
        buffer.append(this.table);
        buffer.append("]");
        return buffer.toString();
    }

    public String getFolderName() {
        if (this.folder == null) {
            return "TABLE";
        }
        return this.folder.getName();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    public void setRemarks(String remarks) {
        throw new UnsupportedOperationException("ContentAssistTable#setRemarks\u306f\u5b9f\u88c5\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public TableConstraintColumn[] getTableConstraintColumns() {
        return this.table.getTableConstraintColumns();
    }

    public void setTableConstraintColumns(TableConstraintColumn[] tableConstraintColumns) {
        this.table.setTableConstraintColumns(tableConstraintColumns);
    }
}

