/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.IStatusChangeListener;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.PropertyPageChangeListener;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.actions.AutoDelayListener;
import zigen.plugin.db.ui.actions.GlobalAction;
import zigen.plugin.db.ui.editors.sql.IPropertyPageChangeListener;
import zigen.plugin.db.ui.editors.sql.ISqlEditor;
import zigen.plugin.db.ui.editors.sql.SqlEditorContributor;
import zigen.plugin.db.ui.util.FileUtil;
import zigen.plugin.db.ui.util.ResourceUtil;
import zigen.plugin.db.ui.util.StyledTextUtil;
import zigen.plugin.db.ui.views.CommitModeAction;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCharacterPairMatcher;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLOutinePage;
import zigen.plugin.db.ui.views.internal.SQLPartitionScanner;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;
import zigen.plugin.db.ui.views.internal.SQLToolBarForSqlEditor;

public class SqlEditor
extends TextEditor
implements ISqlEditor,
IPropertyChangeListener,
IStatusChangeListener,
IPropertyPageChangeListener {
    protected ImageCacher ic = ImageCacher.getInstance();
    protected SQLSourceViewer sqlViewer;
    protected SQLCodeConfiguration sqlConfiguration;
    protected ColorManager colorManager;
    protected LineNumberRulerColumn rulerCol;
    protected IPreferenceStore store;
    protected ProjectionSupport projectionSupport;
    protected Map fGlobalActions = new HashMap();
    protected SQLToolBarForSqlEditor toolBar;
    protected SQLOutinePage outlinePage;
    boolean dirty;
    private Annotation[] fOccurrenceAnnotations;
    private IRegion fMarkOccurrenceTargetRegion;
    private long fMarkOccurrenceModificationStamp = -1L;
    private ISelection fForcedMarkOccurrencesSelection;

    public SqlEditor() {
        this.colorManager = new ColorManager();
        this.sqlConfiguration = new SQLCodeConfiguration(this.colorManager);
        this.setSourceViewerConfiguration(this.sqlConfiguration);
        this.store = DbPlugin.getDefault().getPreferenceStore();
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
        DbPlugin.addStatusChangeListener(this);
        PropertyPageChangeListener.addPropertyPageChangeListener(this);
    }

    public IFile getFile() {
        FileEditorInput fi = (FileEditorInput)this.getEditorInput();
        return fi.getFile();
    }

    public void propertyPageChanged(Object obj, int status) {
        if (status == 101) {
            IDBConfig config = ResourceUtil.getDBConfig((IResource)this.getFile());
            this.toolBar.updateCombo(config);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.sqlViewer = (SQLSourceViewer)this.getSourceViewer();
        DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
        IDocument doc = this.sqlViewer.getDocument();
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new SQLPartitionScanner(), new String[]{"__sql_string", "__sql_comment"});
        partitioner.connect(doc);
        doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        SQLSourceViewer extension = this.sqlViewer;
        MatchingCharacterPainter painter = new MatchingCharacterPainter((ISourceViewer)this.sqlViewer, (ICharacterPairMatcher)new SQLCharacterPairMatcher());
        painter.setColor(this.colorManager.getColor("SQLEditorPreferencePage.ColorMatching"));
        extension.addPainter((IPainter)painter);
        ProjectionViewer pviewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(pviewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        pviewer.doOperation(19);
        this.updateFolding();
        StyledTextUtil.changeColor(this.colorManager, this.sqlViewer.getTextWidget());
        this.hookContextMenu();
        this.toolBar.setSQLSourceViewer(this.sqlViewer);
        this.toolBar.updateCombo(ResourceUtil.getDBConfig((IResource)this.getFile()));
        this.sqlViewer.getTextWidget().addKeyListener((KeyListener)new AutoDelayAdapter());
        this.sqlViewer.getTextWidget().addMouseListener((MouseListener)new AutoDelayAdapter());
        this.getSite().setSelectionProvider((ISelectionProvider)this.sqlViewer);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.toolBar = new SQLToolBarForSqlEditor((IEditorPart)this);
        this.toolBar.createPartControl(parent);
        Composite sqlComposite = new Composite(parent, 0);
        sqlComposite.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.toolBar.getCoolBar(), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        sqlComposite.setLayoutData((Object)data);
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        SQLSourceViewer viewer = new SQLSourceViewer(sqlComposite, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        IDBConfig config = FileUtil.getDBConfig(this.getFile());
        if (config != null) {
            this.toolBar.updateCombo(config);
            this.changeTitleImageAndCommitModeText(config);
        }
        return viewer;
    }

    void changeTitleImageAndCommitModeText(IDBConfig config) {
        try {
            if (config != null && this.toolBar != null && this.toolBar.getConfig() != null && config.getDbName().equals(this.toolBar.getConfig().getDbName())) {
                Transaction trans = Transaction.getInstance(config);
                if (trans.isConneting()) {
                    super.setTitleImage(this.ic.getImage("connecteddb.gif"));
                } else {
                    super.setTitleImage(this.ic.getImage("db.gif"));
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SqlEditor.this.getContributor().fillContextMenu(manager);
            }
        });
        StyledText text = this.sqlViewer.getTextWidget();
        Menu menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.sqlViewer);
    }

    private SqlEditorContributor getContributor() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof SqlEditorContributor) {
            return (SqlEditorContributor)contributor;
        }
        return null;
    }

    public String getEditingSource() {
        return this.getSourceViewer().getDocument().get();
    }

    protected IStatusLineManager getIStatusLineManager() {
        IEditorSite site = super.getEditorSite();
        IActionBars actionBars = site.getActionBars();
        return actionBars.getStatusLineManager();
    }

    public void dispose() {
        this.colorManager.dispose();
        DbPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        DbPlugin.removeStatusChangeListener(this);
        PropertyPageChangeListener.removePropertyPageChangeListener(this);
        super.dispose();
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.sqlConfiguration != null && this.sqlViewer != null) {
            this.sqlConfiguration.updatePreferences(this.sqlViewer.getDocument());
            StyledTextUtil.changeColor(this.colorManager, this.sqlViewer.getTextWidget());
            this.sqlViewer.invalidateTextPresentation();
        }
    }

    protected void setGlobalAction() {
        IActionBars actionBars = this.getEditorSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 2));
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 6));
        actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 7));
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 4));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 5));
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)new GlobalAction((TextViewer)this.sqlViewer, 3));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1003));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLCurrentExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1004));
        this.setGlobalAction(actionBars, "zigen.plugin.db.actions.SQLSelectedExecuteAction", (IAction)new GlobalAction((TextViewer)this.sqlViewer, 1005));
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    public void setFocus() {
        this.setGlobalAction();
    }

    public IDBConfig getConfig() {
        return this.toolBar.getConfig();
    }

    public Object getAdapter(Class adapter) {
        Object obj;
        if (this.projectionSupport != null && (obj = this.projectionSupport.getAdapter(this.getSourceViewer(), adapter)) != null) {
            return obj;
        }
        return super.getAdapter(adapter);
    }

    protected void updateFolding() {
    }

    public void doSave(IProgressMonitor progressMonitor) {
        super.doSave(progressMonitor);
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
        this.updateFolding();
        this.saveProperties();
        this.setDirty(false);
    }

    public void doSaveAs() {
        this.doSave(null);
    }

    protected void saveProperties() {
        if (this.getConfig() != null) {
            try {
                String dbName = this.getConfig().getDbName();
                this.getFile().setPersistentProperty(new QualifiedName("zigen.plugin.db", "SELECTED_DB"), dbName);
                PropertyPageChangeListener.firePropertyPageChangeListener(this, 101);
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean value) {
        this.dirty = value;
        this.firePropertyChange(257);
    }

    public void statusChanged(Object obj, int status) {
        if (status == 107) {
            this.toolBar.initializeSelectCombo();
        } else if (status == 102) {
            if (obj instanceof CommitModeAction) {
                CommitModeAction action = (CommitModeAction)((Object)obj);
                this.toolBar.setCommitMode(action.getDbConfig(), action.isAutoCommit());
            }
        } else if (status == 106) {
            this.setDirty(true);
        }
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    public SQLSourceViewer getSqlViewer() {
        return this.sqlViewer;
    }

    class AutoDelayAdapter
    extends AutoDelayListener {
        AutoDelayAdapter() {
        }

        public Runnable createExecutAction() {
            return new Runnable(){

                public void run() {
                    try {
                        if (((AutoDelayAdapter)AutoDelayAdapter.this).SqlEditor.this.outlinePage != null) {
                            ((AutoDelayAdapter)AutoDelayAdapter.this).SqlEditor.this.outlinePage.update();
                        }
                    }
                    catch (Exception exception) {}
                }
            };
        }
    }

    class OccurrencesFinderJob
    extends Job {
        private IDocument fDocument;
        private ISelection fSelection;
        private ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private IProgressMonitor fProgressMonitor;
        private Position[] fPositions;

        public OccurrencesFinderJob(IDocument document, Position[] positions, ISelection selection) {
            super("");
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fPositions = positions;
            if (SqlEditor.this.getSelectionProvider() instanceof ISelectionValidator) {
                this.fPostSelectionValidator = (ISelectionValidator)SqlEditor.this.getSelectionProvider();
            }
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && SqlEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            SQLSourceViewer textViewer = SqlEditor.this.sqlViewer;
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = SqlEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            SqlEditor.this.fForcedMarkOccurrencesSelection = SqlEditor.this.getSelectionProvider().getSelection();
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)SqlEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fPositions.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                block13: {
                    String message;
                    Position position = this.fPositions[i];
                    try {
                        message = document.get(position.offset, position.length);
                    }
                    catch (BadLocationException badLocationException) {
                        break block13;
                    }
                    annotationMap.put(new Annotation("org.eclipse.jdt.ui.occurrences", false, message), position);
                }
                ++i;
            }
            Object object = SqlEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(SqlEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    SqlEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                SqlEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class SaveAction
    extends Action {
        public SaveAction() {
            this.setToolTipText("Save");
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("save.gif"));
        }

        public void run() {
            SqlEditor.this.doSave(null);
        }
    }
}

