/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceInfo;

public class SequenceEditorInput
implements IEditorInput {
    private String tooltip;
    private String name;
    private IDBConfig config;
    private OracleSequenceInfo sequenceInfo;

    public SequenceEditorInput(IDBConfig config, OracleSequenceInfo sequenceInfo) {
        this.config = config;
        this.sequenceInfo = sequenceInfo;
        this.tooltip = this.name = String.valueOf(sequenceInfo.getSequence_name()) + "[SEQUENCE]";
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SequenceEditorInput) {
            SequenceEditorInput input = (SequenceEditorInput)o;
            if (this.config.getDbName().equals(input.config.getDbName())) {
                return this.name.equals(input.getName());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }

    public OracleSequenceInfo getSequenceInfo() {
        return this.sequenceInfo;
    }

    public void setSequenceInfo(OracleSequenceInfo sequenceInfo) {
        this.sequenceInfo = sequenceInfo;
    }
}

