/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.sql;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.MarkerUtilities;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ui.editors.sql.IPlsqlEditor;
import zigen.plugin.db.ui.editors.sql.PlsqlEditorContributor;
import zigen.plugin.db.ui.editors.sql.SqlEditor2;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.PLSQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.PLSQLSourceViewer;
import zigen.plugin.db.ui.views.internal.SQLToolBarForPlsqlEditor;

public class PlsqlEditor
extends SqlEditor2
implements IPlsqlEditor,
IPropertyChangeListener,
IDocumentListener {
    IResource resource = null;

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        this.setDirty(true);
    }

    public PlsqlEditor() {
        this.colorManager = new ColorManager();
        this.sqlConfiguration = new PLSQLCodeConfiguration(this.colorManager);
        this.setSourceViewerConfiguration(this.sqlConfiguration);
        this.store = DbPlugin.getDefault().getPreferenceStore();
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        this.resource = (IResource)this.getEditorInput().getAdapter(IResource.class);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.toolBar = new SQLToolBarForPlsqlEditor((IEditorPart)this);
        this.toolBar.createPartControl(parent);
        Composite sqlComposite = new Composite(parent, 0);
        sqlComposite.setLayout((Layout)new FillLayout());
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.toolBar.getCoolBar(), 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        sqlComposite.setLayoutData((Object)data);
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        PLSQLSourceViewer viewer = new PLSQLSourceViewer(sqlComposite, ruler, this.getOverviewRuler(), true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        viewer.setPlsqlEditor(this);
        return viewer;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                PlsqlEditor.this.getContributor().fillContextMenu(manager);
            }
        });
        StyledText text = this.sqlViewer.getTextWidget();
        Menu menu = menuMgr.createContextMenu((Control)text);
        text.setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.sqlViewer);
    }

    private PlsqlEditorContributor getContributor() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof PlsqlEditorContributor) {
            return (PlsqlEditorContributor)contributor;
        }
        return null;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            super.doSave(progressMonitor);
            this.clearError();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        try {
            super.doSaveAs();
            this.clearError();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.add((IContributionItem)new Separator());
    }

    public PLSQLSourceViewer getPLSQLSourceViewer() {
        return (PLSQLSourceViewer)this.sqlViewer;
    }

    public void clearError() {
        try {
            this.resource.deleteMarkers(null, true, 0);
        }
        catch (CoreException e) {
            DbPlugin.getDefault().getLog().log(e.getStatus());
        }
    }

    public void setError(OracleSourceErrorInfo[] errors) {
        if (this.resource != null) {
            try {
                this.getSourceViewer().getTextWidget();
                IDocument doc = this.getSourceViewer().getDocument();
                int i = 0;
                while (i < errors.length) {
                    OracleSourceErrorInfo info = errors[i];
                    int errorLine = info.getLine() > 0 ? info.getLine() - 1 : 0;
                    int errorPosition = info.getPosition() > 0 ? info.getPosition() - 1 : 0;
                    try {
                        IRegion region = doc.getLineInformation(errorLine);
                        int len = region.getLength() > 0 ? region.getLength() - 1 : 0;
                        String str = doc.get(region.getOffset() + errorPosition, len);
                        String target = str.replaceAll("\\p{Space}.*", "");
                        TextSelection selection = new TextSelection(doc, region.getOffset() + errorPosition, target.length());
                        if (!selection.isEmpty()) {
                            int start = selection.getOffset();
                            int length = selection.getLength();
                            if (length < 0) {
                                length = -length;
                                start -= length;
                            }
                            HashMap<String, Object> attributes = new HashMap<String, Object>();
                            MarkerUtilities.setCharStart(attributes, (int)start);
                            MarkerUtilities.setCharEnd(attributes, (int)(start + length));
                            int line = selection.getStartLine();
                            MarkerUtilities.setLineNumber(attributes, (int)(line == -1 ? -1 : errorLine));
                            MarkerUtilities.setMessage(attributes, (String)info.getErrorText());
                            attributes.put("severity", new Integer(2));
                            attributes.put("selection", selection.getText() == null ? "" : selection.getText());
                            MarkerUtilities.createMarker((IResource)this.resource, attributes, (String)"zigen.plugin.db.markers.myProblem");
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                DbPlugin.getDefault().getLog().log(e.getStatus());
            }
        }
    }
}

