/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.wizard;

import java.util.Collections;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.core.ColumnSeqSorter;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.editors.internal.wizard.Messages;
import zigen.plugin.db.ui.editors.internal.wizard.PKWizardPage;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class IndexWizardPage
extends PKWizardPage {
    public static final String MSG_DSC = Messages.getString("IndexWizardPage.0");
    private static final String MSG_REQUIRE_NAME = Messages.getString("IndexWizardPage.1");
    private static final String MSG_REQUIRE_COLUMN = Messages.getString("IndexWizardPage.2");
    int indexType = 0;
    Text txtIndexName;

    public IndexWizardPage(ISQLCreatorFactory factory, ITable table) {
        super(factory, table);
        this.setTitle(Messages.getString("IndexWizardPage.3"));
    }

    public void createNameConstrol(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("IndexWizardPage.4"));
        this.txtIndexName = new Text(composite, 2048);
        GridData gd = new GridData(768);
        this.txtIndexName.setLayoutData((Object)gd);
        this.txtIndexName.setText("");
        this.txtIndexName.addFocusListener((FocusListener)new TextSelectionListener());
        this.txtIndexName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if ("".equals(IndexWizardPage.this.txtIndexName.getText())) {
                    IndexWizardPage.this.updateStatus(MSG_REQUIRE_NAME);
                } else if (IndexWizardPage.this.selectedList.isEmpty()) {
                    IndexWizardPage.this.updateStatus(MSG_REQUIRE_COLUMN);
                } else {
                    IndexWizardPage.this.updateStatus(null);
                }
            }
        });
    }

    protected void createOptionControl(Composite container) {
        Composite base = new Composite(container, 0);
        base.setLayout((Layout)new RowLayout());
        final Button chkNonUniqueIndex = new Button(base, 16);
        chkNonUniqueIndex.setText("NonUnique Index");
        chkNonUniqueIndex.setSelection(true);
        chkNonUniqueIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (chkNonUniqueIndex.getSelection()) {
                    IndexWizardPage.this.indexType = 0;
                }
            }
        });
        final Button chkUniqueIndex = new Button(base, 16);
        chkUniqueIndex.setText("Unique Index");
        chkUniqueIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (chkUniqueIndex.getSelection()) {
                    IndexWizardPage.this.indexType = 1;
                }
            }
        });
        if (DBType.getType(this.tableNode.getDbConfig()) == 1) {
            final Button chkBitmapIndex = new Button(base, 16);
            chkBitmapIndex.setText("BitMap Index");
            chkBitmapIndex.setSelection(false);
            chkBitmapIndex.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (chkBitmapIndex.getSelection()) {
                        IndexWizardPage.this.indexType = 2;
                    }
                }
            });
        }
    }

    protected void update() {
        Collections.sort(this.columnList, new ColumnSeqSorter());
        this.selectColumnViewer.setInput((Object)this.selectedList.toArray(new Column[0]));
        this.columnViewer.setInput((Object)this.columnList.toArray(new Column[0]));
        this.columnsPack(this.selectColumnViewer.getTable());
        this.columnsPack(this.columnViewer.getTable());
        if ("".equals(this.txtIndexName.getText())) {
            this.updateStatus(MSG_REQUIRE_NAME);
        } else if (this.selectedList.isEmpty()) {
            this.updateStatus(MSG_REQUIRE_COLUMN);
        } else {
            this.updateStatus(null);
        }
    }

    public int getIndexType() {
        return this.indexType;
    }
}

