/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.thread;

import java.sql.Connection;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.internal.thread.Messages;
import zigen.plugin.db.ui.internal.ITable;

public abstract class AbstractSQLThread
implements Runnable {
    protected ITable table;
    protected IDBConfig config;
    protected ISQLCreatorFactory factory;

    public AbstractSQLThread(ITable table) {
        this.table = table;
        this.config = table.getDbConfig();
        this.factory = AbstractSQLCreatorFactory.getFactory(this.config, table);
    }

    public void run() {
        this.executeUpdate(this.createSQL(this.factory, this.table));
    }

    abstract String[] createSQL(ISQLCreatorFactory var1, ITable var2);

    public void executeUpdate(String[] sqls) {
        String _sql = "";
        try {
            if (sqls == null || sqls.length == 0) {
                DbPlugin.getDefault().showWarningMessage(Messages.getString("AbstractSQLThread.2"));
                return;
            }
            Connection con = Transaction.getInstance(this.table.getDbConfig()).getConnection();
            int i = 0;
            while (i < sqls.length) {
                _sql = sqls[i];
                SQLInvoker.execute(con, _sql);
                ++i;
            }
            this.doAfterExecuteUpdate(this.table);
            Transaction trans = Transaction.getInstance(this.config);
            if (!this.config.isAutoCommit() && this.factory.supportsRollbackDDL() && DbPlugin.getDefault().confirmDialog(Messages.getString("AbstractSQLThread.3"))) {
                trans.commit();
            }
            DbPlugin.fireStatusChangeListener(this.table, 103);
            return;
        }
        catch (Exception e) {
            DbPlugin.log(String.valueOf(Messages.getString("AbstractSQLThread.4")) + _sql);
            DbPlugin.getDefault().showErrorDialog(e);
            return;
        }
    }

    protected void doAfterExecuteUpdate(ITable table) {
    }
}

