/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal;

import java.sql.Connection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DeleteSQLInvoker;
import zigen.plugin.db.core.SQLCreator;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.internal.Messages;
import zigen.plugin.db.ui.editors.internal.TableEditorLogUtil;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;

public class RecordDeleteThread
implements Runnable {
    private ITableViewEditor editor;
    private TableViewer viewer;
    private ITable table;

    private RecordDeleteThread(ITableViewEditor editor, ITable table) {
        this.editor = editor;
        this.viewer = editor.getViewer();
        this.table = table;
    }

    public void run() {
        TransactionForTableEditor trans = null;
        int rowAffected = 0;
        try {
            trans = TransactionForTableEditor.getInstance(this.table.getDbConfig());
            rowAffected = this.delete(trans.getConnection());
            if (DbPlugin.getDefault().confirmDialog(String.valueOf(rowAffected) + Messages.getString("RecordDeleteThread.0"))) {
                trans.commit();
                this.removeElement();
            } else {
                trans.rollback();
            }
            this.editor.changeColumnColor();
        }
        catch (Exception e) {
            if (trans != null) {
                trans.rollback();
            }
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private int delete(Connection con) throws Exception {
        int rowAffected = 0;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object obj : selection) {
            if (!(obj instanceof TableElement)) continue;
            TableElement elem = (TableElement)obj;
            TableColumn[] uniqueColumns = elem.getUniqueColumns();
            Object[] uniqueItems = elem.getUniqueItems();
            String sql = SQLCreator.createDeleteSql(this.table, uniqueColumns, uniqueItems);
            int row = DeleteSQLInvoker.invoke(con, this.table, uniqueColumns, uniqueItems);
            if (row > 0) {
                TableEditorLogUtil.successLog(sql);
            } else {
                TableEditorLogUtil.failureLog(sql);
            }
            rowAffected += row;
        }
        return rowAffected;
    }

    private void removeElement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object obj : selection) {
            if (!(obj instanceof TableElement)) continue;
            TableViewerManager.remove(this.viewer, (TableElement)obj);
        }
    }
}

