/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.contentassist.ContentInfo;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class ContentAssist {
    protected TableContentProvider contentProvider = new TableContentProvider();
    private TableViewer tableViewer;
    private Rectangle rectangle;
    private Display display;
    private Combo comb;
    private ITable table;
    private Column[] columns;

    public ContentAssist(Combo text, ITable table) {
        this.comb = text;
        this.rectangle = this.getRectangle(text);
        this.display = DbPlugin.getDefault().getShell().getDisplay();
        this.table = table;
        ContentInfo ci = new ContentInfo(table.getDbConfig());
        this.columns = ci.getColumns(table.getName());
        this.createComposite();
    }

    private Rectangle getRectangle(Combo text) {
        Rectangle rectangle = new Rectangle(text.getBorderWidth(), 0, 0, 0);
        Composite parent = text.getParent();
        while (parent != null) {
            if (!(parent instanceof Composite)) continue;
            rectangle.x += parent.getBounds().x;
            rectangle.y += parent.getBounds().y;
            parent = parent.getParent();
        }
        rectangle.x += text.getBounds().x;
        rectangle.y += text.getBounds().y + 0 + 60;
        return rectangle;
    }

    private Rectangle getRectangle(Text text) {
        Rectangle rectangle = new Rectangle(text.getBorderWidth(), text.getLineHeight(), 0, 0);
        Composite parent = text.getParent();
        while (parent != null) {
            if (!(parent instanceof Composite)) continue;
            rectangle.x += parent.getBounds().x;
            rectangle.y += parent.getBounds().y;
            parent = parent.getParent();
        }
        rectangle.x += text.getBounds().x + text.getCaretLocation().x;
        rectangle.y += text.getBounds().y + text.getLineHeight();
        return rectangle;
    }

    protected void createComposite() {
        final Shell composite = new Shell(this.display, 16384);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.tableViewer = new TableViewer((Composite)composite, 772);
        final Table table = this.tableViewer.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gridData = new GridData(1808);
        this.tableViewer.getControl().setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setInput((Object)this.columns);
        table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (table.getSelectionIndex() == -1) {
                    table.select(0);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    TableItem item = table.getItem(table.getSelectionIndex());
                    ContentAssist.this.comb.setText(item.getText());
                    e.doit = false;
                    composite.close();
                }
            }
        });
        composite.setSize(300, 100);
        composite.setLocation(this.rectangle.x, this.rectangle.y);
        composite.open();
        composite.forceActive();
        composite.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                ((Shell)e.getSource()).dispose();
            }
        });
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        Object[] contents;

        private TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.contents;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = newInput instanceof Object[] ? (Object[])newInput : null;
        }

        public void dispose() {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Column) {
                Column col = (Column)element;
                return col.getName();
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof Column) {
                Column col = (Column)obj;
                if (col.hasPrimaryKey()) {
                    return DbPlugin.getDefault().getImage("primarykey.gif");
                }
                if (col.isNotNull()) {
                    return DbPlugin.getDefault().getImage("notNull.gif");
                }
                return DbPlugin.getDefault().getImage("column.gif");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

