/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.event;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TabTokenizer;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableNewElement;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.QueryViewEditor2;
import zigen.plugin.db.ui.editors.event.PasteRecordMonitor;
import zigen.plugin.db.ui.editors.event.TableKeyEventHandler;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.jobs.AbstractJob;
import zigen.plugin.db.ui.jobs.RecordCountForTableJob;

public class TableKeyAdapter
implements KeyListener,
TraverseListener {
    private TableKeyEventHandler handler;
    private ITableViewEditor editor;
    TableColumn[] columns;
    int columnCount;
    TableElement headerTableElement;
    Table table;

    public TableKeyAdapter(TableKeyEventHandler handler) {
        this.handler = handler;
        this.editor = handler.editor;
        this.table = handler.table;
        this.headerTableElement = handler.getHeaderTableElement();
        if (this.headerTableElement != null) {
            this.columns = this.headerTableElement.getColumns();
            this.columnCount = this.columns.length;
        }
    }

    public void keyTraversed(TraverseEvent e) {
        int row = this.handler.getSelectedRow();
        int col = this.handler.getSelectedCellEditorIndex();
        if (e.character == '\t') {
            if ((e.stateMask & 0x20000) != 0) {
                if (this.handler.validate(row, col)) {
                    int prevCol = this.handler.getEditablePrevColumn(col);
                    this.handler.editTableElement(row, prevCol);
                }
            } else if (this.handler.validate(row, col)) {
                int nextCol = this.handler.getEditableNextColumn(col);
                this.handler.editTableElement(row, nextCol);
            }
            e.doit = false;
        }
    }

    private void enterEvent(KeyEvent e) throws Exception {
        int row = this.handler.getSelectedRow();
        int col = this.handler.getSelectedCellEditorIndex();
        TableElement element = (TableElement)this.handler.viewer.getElementAt(row);
        if (!this.handler.validate(row, col)) {
            e.doit = false;
        } else if (this.handler.updateDataBase(element)) {
            this.editor.changeColumnColor();
            this.handler.selectRow(row);
            e.doit = true;
        } else {
            e.doit = false;
        }
    }

    private void arrowEvent(KeyEvent e, Text text) throws Exception {
        int row = this.handler.getSelectedRow();
        int col = this.handler.getSelectedCellEditorIndex();
        int prevCol = this.handler.getEditablePrevColumn(col);
        int nextCol = this.handler.getEditableNextColumn(col);
        int maxRow = this.handler.table.getItemCount();
        int maxCol = this.handler.table.getColumnCount();
        int caretPostion = text.getCaretPosition();
        int carCount = text.getCharCount();
        int selectionCount = text.getSelectionCount();
        TableElement element = (TableElement)this.handler.viewer.getElementAt(row);
        switch (e.keyCode) {
            case 0x1000001: {
                if (row < 0) break;
                if (this.handler.validate(row, col)) {
                    if (element.isNew() && !element.isModify()) {
                        this.handler.removeRecord(element);
                        this.handler.editTableElement(row - 1, col);
                    } else if (this.handler.updateDataBase(element)) {
                        this.editor.changeColumnColor();
                        this.handler.editTableElement(row - 1, col);
                    } else {
                        this.handler.editTableElement(row, col);
                    }
                }
                e.doit = false;
                break;
            }
            case 0x1000002: {
                if (row < maxRow - 1) {
                    if (this.handler.validate(row, col)) {
                        if (this.handler.updateDataBase(element)) {
                            this.handler.editTableElement(row + 1, col);
                        } else {
                            this.handler.editTableElement(row, col);
                        }
                    }
                    e.doit = false;
                    break;
                }
                if (this.handler.validate(row, col)) {
                    if (!element.isNew()) {
                        if (this.handler.updateDataBase(element)) {
                            if (!(this.editor instanceof QueryViewEditor2)) {
                                this.handler.createNewRecord();
                            }
                        } else {
                            this.handler.editTableElement(row, col);
                        }
                    } else if (element.isModify()) {
                        if (this.handler.updateDataBase(element)) {
                            this.handler.createNewRecord();
                        } else {
                            this.handler.editTableElement(row, col);
                        }
                    }
                }
                e.doit = false;
                break;
            }
            case 0x1000003: {
                if (col == 1) {
                    if (selectionCount == carCount) {
                        e.doit = false;
                        break;
                    }
                    e.doit = true;
                    break;
                }
                if (col > 1) {
                    if ((selectionCount != 0 || caretPostion != 0) && selectionCount != carCount) break;
                    this.handler.editTableElement(row, prevCol);
                    e.doit = false;
                    break;
                }
                e.doit = false;
                break;
            }
            case 0x1000004: {
                if (col == maxCol - 1) {
                    if (selectionCount == carCount) {
                        e.doit = false;
                        break;
                    }
                    e.doit = true;
                    break;
                }
                if (col < maxCol - 1) {
                    if (selectionCount != carCount && caretPostion != carCount) break;
                    this.handler.editTableElement(row, nextCol);
                    e.doit = false;
                    break;
                }
                e.doit = false;
                break;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        Text text = null;
        try {
            if (e.widget instanceof Text) {
                text = (Text)e.widget;
                if (e.character == '\r') {
                    this.enterEvent(e);
                } else if (e.keyCode == 0x100000B) {
                    text.clearSelection();
                } else if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                    this.arrowEvent(e, text);
                }
                if (e.stateMask == 262144 && e.keyCode == 118 && this.createNewElement()) {
                    e.doit = false;
                }
            } else if (e.widget instanceof Button && (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004)) {
                this.arrowEvent(e);
            }
        }
        catch (Exception e1) {
            DbPlugin.getDefault().showErrorDialog(e1);
        }
    }

    private boolean isHeaderData(TableColumn[] colums, String[] items) {
        boolean isHeader = true;
        if (colums.length != items.length) {
            return false;
        }
        int i = 0;
        while (i < colums.length) {
            TableColumn col = colums[i];
            if (!col.getColumnName().equals(items[i])) {
                isHeader = false;
            }
            ++i;
        }
        return isHeader;
    }

    private boolean isRecordData(String target, int columnCount) {
        if (target == null || "".equals(target)) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(target, DbPluginConstant.LINE_SEP);
        while (tokenizer.hasMoreTokens()) {
            StringBuffer sb = new StringBuffer();
            sb.append(tokenizer.nextToken()).append(DbPluginConstant.LINE_SEP);
            TabTokenizer t = new TabTokenizer(sb.toString());
            if (columnCount == t.getTokenCount()) continue;
            return false;
        }
        return true;
    }

    private String getCurrentClipboard() {
        String result = null;
        Clipboard cp = ClipboardUtils.getInstance();
        TextTransfer transfer = TextTransfer.getInstance();
        String[] v = cp.getAvailableTypeNames();
        int i = 0;
        while (i < v.length) {
            if (v[i].equals("CF_TEXT") && (result = (String)cp.getContents((Transfer)transfer)) != null) {
                return result;
            }
            ++i;
        }
        return result;
    }

    public boolean canCreateNewElement() {
        String str = this.getCurrentClipboard();
        if (this.isRecordData(str, this.columnCount)) {
            if (str == null) {
                return false;
            }
            StringTokenizer tokenizer = new StringTokenizer(str, DbPluginConstant.LINE_SEP);
            while (tokenizer.hasMoreTokens()) {
                String record = tokenizer.nextToken();
                String[] items = record.split("\t");
                if (this.isHeaderData(this.columns, items)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean createNewElement() throws Exception {
        String str = this.getCurrentClipboard();
        if (this.isRecordData(str, this.columnCount)) {
            StringTokenizer tokenizer = new StringTokenizer(str, DbPluginConstant.LINE_SEP);
            int position = this.editor.getRecordOffset() + this.table.getItemCount();
            PasteRecordJob job = new PasteRecordJob(tokenizer, position);
            job.setPriority(30);
            job.setUser(true);
            job.schedule();
            return true;
        }
        return false;
    }

    private void arrowEvent(KeyEvent e) throws Exception {
        int row = this.handler.getSelectedRow();
        int col = this.handler.getSelectedCellEditorIndex();
        int prevCol = this.handler.getEditablePrevColumn(col);
        int nextCol = this.handler.getEditableNextColumn(col);
        int maxRow = this.handler.table.getItemCount();
        int maxCol = this.handler.table.getColumnCount();
        TableElement element = (TableElement)this.handler.viewer.getElementAt(row);
        switch (e.keyCode) {
            case 0x1000001: {
                if (row < 0) break;
                if (this.handler.validate(row, col)) {
                    if (element.isNew() && !element.isModify()) {
                        this.handler.removeRecord(element);
                        this.handler.editTableElement(row - 1, col);
                    } else if (this.handler.updateDataBase(element)) {
                        this.editor.changeColumnColor();
                        this.handler.editTableElement(row - 1, col);
                    } else {
                        this.handler.editTableElement(row, col);
                    }
                }
                e.doit = false;
                break;
            }
            case 0x1000002: {
                if (row < maxRow - 1) {
                    if (this.handler.validate(row, col)) {
                        if (this.handler.updateDataBase(element)) {
                            this.handler.editTableElement(row + 1, col);
                        } else {
                            this.handler.editTableElement(row, col);
                        }
                    }
                    e.doit = false;
                    break;
                }
                if (this.handler.validate(row, col)) {
                    if (!element.isNew()) {
                        if (this.handler.updateDataBase(element)) {
                            if (!(this.editor instanceof QueryViewEditor2)) {
                                this.handler.createNewRecord();
                            }
                        } else {
                            this.handler.editTableElement(row, col);
                        }
                    } else if (element.isModify()) {
                        if (this.handler.updateDataBase(element)) {
                            this.handler.createNewRecord();
                        } else {
                            this.handler.editTableElement(row, col);
                        }
                    }
                }
                e.doit = false;
                break;
            }
            case 0x1000003: {
                if (col == 1) {
                    e.doit = true;
                    break;
                }
                if (col > 1) {
                    this.handler.editTableElement(row, prevCol);
                    e.doit = false;
                    break;
                }
                e.doit = false;
                break;
            }
            case 0x1000004: {
                if (col == maxCol - 1) {
                    e.doit = true;
                    break;
                }
                if (col < maxCol - 1) {
                    this.handler.editTableElement(row, nextCol);
                    e.doit = false;
                    break;
                }
                e.doit = false;
                break;
            }
        }
    }

    static /* synthetic */ boolean access$2(TableKeyAdapter tableKeyAdapter, TableColumn[] tableColumnArray, String[] stringArray) {
        return tableKeyAdapter.isHeaderData(tableColumnArray, stringArray);
    }

    class CalcTotalCountAction
    implements Runnable {
        CalcTotalCountAction() {
        }

        public void run() {
            TableElement[] elements = (TableElement[])((TableKeyAdapter)TableKeyAdapter.this).handler.viewer.getInput();
            int dispCnt = 0;
            int i = 1;
            while (i < elements.length) {
                if (!elements[i].isNew()) {
                    ++dispCnt;
                }
                ++i;
            }
            TableKeyAdapter.this.editor.setTotalCount(dispCnt, -1L);
            IDBConfig config = TableKeyAdapter.this.editor.getDBConfig();
            ITable tableNode = TableKeyAdapter.this.editor.getTableNode();
            String condition = TableKeyAdapter.this.editor.getCondition();
            RecordCountForTableJob job2 = new RecordCountForTableJob(Transaction.getInstance(config), tableNode, condition, dispCnt, true);
            job2.setUser(false);
            job2.schedule();
        }
    }

    class PasteRecordJob
    extends AbstractJob {
        StringTokenizer tokenizer;
        int position;

        public PasteRecordJob(StringTokenizer tokenizer, int position) {
            super("Paste Record Data");
            this.tokenizer = tokenizer;
            TableKeyAdapter.this.editor.setEnabled(false);
            this.position = position;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            block15: {
                block14: {
                    try {
                        var2_2 = TableKeyAdapter.this.table;
                        synchronized (var2_2) {
                            totalWork = this.tokenizer.countTokens();
                            monitor.beginTask("Now Pasting Records...", totalWork);
                            cnt = 0;
                            displayCount = 0;
lbl9:
                            // 3 sources

                            while (true) {
                                if (!this.tokenizer.hasMoreTokens()) {
                                    break;
                                }
                                ++cnt;
                                ++displayCount;
                                if (!monitor.isCanceled()) ** break block13
                                var11_11 = Status.CANCEL_STATUS;
                                break block14;
                                break;
                            }
                        }
                        monitor.done();
                        break block15;
                    }
                    catch (Exception e) {
                        this.showErrorMessage("The error occurred. ", e);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                TableKeyAdapter.this.editor.changeColumnColor();
                                TableKeyAdapter.this.editor.setEnabled(true);
                            }
                        });
                        Display.getDefault().asyncExec((Runnable)new CalcTotalCountAction());
                        return Status.OK_STATUS;
                    }
                    catch (Throwable var10_12) {
                        Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                        Display.getDefault().asyncExec((Runnable)new CalcTotalCountAction());
                        throw var10_12;
                    }
                }
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                Display.getDefault().asyncExec((Runnable)new CalcTotalCountAction());
                return var11_11;
                {
                    record = this.tokenizer.nextToken();
                    itemList = new ArrayList<String>();
                    t = new TabTokenizer(record);
                    while (true) {
                        block16: {
                            if (t.hasMoreElements()) break block16;
                            items = itemList.toArray(new String[0]);
                            if (cnt != 1 || !TableKeyAdapter.access$2(TableKeyAdapter.this, TableKeyAdapter.this.columns, (String[])items)) break;
                            monitor.subTask(String.valueOf(--displayCount) + "/" + --totalWork);
                            monitor.worked(1);
                            ** GOTO lbl9
                        }
                        token = this.convertToken(t.nextToken());
                        itemList.add(token);
                    }
                    monitor.subTask(String.valueOf(displayCount) + "/" + totalWork);
                    monitor.worked(1);
                    Display.getDefault().syncExec((Runnable)new UpdateTableAction(this.position++, items));
                    ** continue;
                }
            }
            Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            Display.getDefault().asyncExec((Runnable)new CalcTotalCountAction());
            return Status.OK_STATUS;
        }

        private String convertToken(String token) {
            if (token == null) {
                token = "";
            }
            if (token.startsWith("\"") && token.endsWith("\"")) {
                token = token.replaceAll("^\"|\"$", "");
                token = token.replaceAll("\"\"", "\"");
            }
            return token;
        }
    }

    class UpdateTableAction
    implements Runnable {
        int recordNo;
        Object[] items;

        public UpdateTableAction(int recordNo, Object[] items) {
            this.recordNo = recordNo;
            this.items = items;
        }

        public void run() {
            PasteRecordMonitor.begin();
            try {
                try {
                    this.createNewRecord(this.recordNo, this.items);
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                    PasteRecordMonitor.end();
                }
            }
            finally {
                PasteRecordMonitor.end();
            }
        }

        private void createNewRecord(int recordNo, Object[] items) throws Exception {
            ITable tbl = TableKeyAdapter.this.headerTableElement.getTable();
            int count = TableKeyAdapter.this.table.getItems().length;
            TableNewElement newElement = new TableNewElement(tbl, recordNo, TableKeyAdapter.this.headerTableElement.getColumns(), items, TableKeyAdapter.this.headerTableElement.getUniqueColumns());
            TableViewerManager.insert(((TableKeyAdapter)TableKeyAdapter.this).handler.viewer, newElement);
            int i = 0;
            while (i < items.length) {
                newElement.addMofiedColumn(i);
                ++i;
            }
            TableKeyAdapter.this.table.setSelection(count);
            TableKeyAdapter.this.handler.updateDataBase(newElement);
            TableKeyAdapter.this.handler.editTableElement(count, 1);
        }
    }
}

