/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.editors.internal.Messages;
import zigen.plugin.db.ui.editors.internal.wizard.ColumnWizard;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.Constraint;
import zigen.plugin.db.ui.internal.ConstraintRoot;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Index;
import zigen.plugin.db.ui.internal.IndexRoot;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.views.TreeViewSorter;

public class TableDefineEditor {
    private List results;
    private String orgTableName;
    private String orgTableComment;
    private Text txtTableName;
    private Text txtTableComment;
    private TableViewer defineViewer;
    private Table table;
    ISQLCreatorFactory factory;
    Composite parent;
    ITable tableNode;
    TableViewEditorFor31 editor;
    private TreeViewer constraintViewer;
    private SashForm sash;
    private boolean focusDefine;
    private ImageCacher ic = ImageCacher.getInstance();

    public TableDefineEditor(Composite parent, ITable tableNode) {
        this.parent = parent;
        this.setTable(tableNode);
    }

    private void setTable(ITable tableNode) {
        this.tableNode = tableNode;
        this.factory = AbstractSQLCreatorFactory.getFactory(tableNode.getDbConfig(), tableNode);
    }

    public void setEditor(TableViewEditorFor31 editor) {
        this.editor = editor;
    }

    public void updateWidget() {
        if (this.tableNode != null) {
            List nonuniqueindexList;
            List uniqueindexList;
            List otherConstraintList;
            List fkList;
            this.table.setVisible(false);
            this.constraintViewer.getTree().setVisible(false);
            this.txtTableName.setText(this.tableNode.getName());
            this.txtTableComment.setText(this.tableNode.getRemarks());
            this.orgTableName = this.tableNode.getName();
            this.orgTableComment = this.tableNode.getRemarks();
            this.defineViewer.setInput((Object)this.tableNode.getColumns());
            this.defineViewer.refresh();
            this.columnsPack(this.table);
            Root root = new Root("root", true);
            ConstraintRoot constraintRoot = new ConstraintRoot();
            IndexRoot indexRoot = new IndexRoot();
            root.addChild(constraintRoot);
            root.addChild(indexRoot);
            Constraint pk = null;
            if (this.tableNode.getTablePKColumns() != null && this.tableNode.getTablePKColumns().length > 0) {
                pk = new Constraint(this.tableNode.getTablePKColumns());
                constraintRoot.addChild(pk);
            }
            if ((fkList = this.factory.convertTableFKColumn(this.tableNode.getTableFKColumns())) != null) {
                for (TablePKColumn[] _fks : fkList) {
                    Constraint fk = new Constraint(_fks);
                    constraintRoot.addChild(fk);
                }
            }
            if ((otherConstraintList = this.factory.convertTableConstraintColumn(this.tableNode.getTableConstraintColumns())) != null) {
                for (TableConstraintColumn[] _cons : otherConstraintList) {
                    Constraint cons = new Constraint(_cons);
                    constraintRoot.addChild(cons);
                }
            }
            if ((uniqueindexList = this.factory.convertTableIDXColumn(this.tableNode.getTableUIDXColumns())) != null) {
                for (TableIDXColumn[] _idx : uniqueindexList) {
                    Index index = new Index(_idx);
                    if (index != null && pk != null && index.getName().equals(pk.getName())) continue;
                    indexRoot.addChild(index);
                }
            }
            if ((nonuniqueindexList = this.factory.convertTableIDXColumn(this.tableNode.getTableNonUIDXColumns())) != null) {
                for (TableIDXColumn[] _idx : nonuniqueindexList) {
                    TreeLeaf leaf;
                    Index index = new Index(_idx);
                    if (index != null && pk != null && index.getName().equals(pk.getName()) || (leaf = indexRoot.getChild(index.getName())) != null) continue;
                    indexRoot.addChild(index);
                }
            }
            this.constraintViewer.setInput((Object)root);
            this.constraintViewer.expandAll();
            this.columnsPack(this.constraintViewer.getTree());
            this.constraintViewer.reveal((Object)constraintRoot);
            TreeColumn col = this.constraintViewer.getTree().getColumns()[0];
            this.constraintViewer.getTree().showColumn(col);
            this.table.setVisible(true);
            this.constraintViewer.getTree().setVisible(true);
        }
    }

    public void createWidget() {
        Composite composite = new Composite(this.parent, 2048);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("TableDefineEditor.1"));
        this.txtTableName = new Text(composite, 2048);
        this.txtTableName.setLayoutData((Object)new GridData(768));
        this.txtTableName.addFocusListener((FocusListener)new TextSelectionListener());
        this.txtTableName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TableDefineEditor.this.editor != null) {
                    TableDefineEditor.this.editor.setDirty(true);
                }
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText(Messages.getString("TableDefineEditor.2"));
        this.txtTableComment = new Text(composite, 2562);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        GC gc = new GC((Drawable)this.txtTableComment);
        gc.setFont(this.txtTableComment.getFont());
        FontMetrics fm = gc.getFontMetrics();
        gridData2.heightHint = fm.getHeight() * 3;
        this.txtTableComment.setLayoutData((Object)gridData2);
        if (this.factory.supportsRemarks()) {
            this.txtTableComment.addFocusListener((FocusListener)new TextSelectionListener());
            this.txtTableComment.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (TableDefineEditor.this.editor != null) {
                        TableDefineEditor.this.editor.setDirty(true);
                    }
                }
            });
        } else {
            this.txtTableComment.setEnabled(false);
        }
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.sash = new SashForm(composite, 512);
        this.sash.setLayoutData((Object)gd);
        this.createTableDefineWidget((Composite)this.sash);
        this.createConstraintWidget((Composite)this.sash);
        this.sash.setWeights(new int[]{65, 35});
    }

    public void createConstraintWidget(Composite comp) {
        this.constraintViewer = new TreeViewer(comp, 68356);
        GridData gd = new GridData(1808);
        gd.minimumHeight = 10;
        this.constraintViewer.getControl().setLayoutData((Object)gd);
        final Tree tree = this.constraintViewer.getTree();
        tree.setFont(DbPlugin.getDefaultFont());
        tree.setHeaderVisible(true);
        tree.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TableDefineEditor.this.setFocusDefine(false);
            }

            public void focusLost(FocusEvent e) {
                tree.deselectAll();
            }
        });
        tree.setLinesVisible(true);
        this.setHeaderColumn2(tree);
        this.constraintViewer.setLabelProvider((IBaseLabelProvider)new ConstraintAndIndexLabelProvider());
        this.constraintViewer.setContentProvider((IContentProvider)new ConstraintAndIndexContentProvider());
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableDefineEditor.this.table.deselectAll();
            }
        });
    }

    private void setHeaderColumn2(Tree tree) {
        TreeColumn col = new TreeColumn(tree, 16384);
        col.setText(Messages.getString("TableDefineEditor.3"));
        col.setWidth(150);
        col.setResizable(true);
        TreeColumn col2 = new TreeColumn(tree, 16384);
        col2.setText(Messages.getString("TableDefineEditor.4"));
        col2.setWidth(150);
        col2.setResizable(true);
        TreeColumn col3 = new TreeColumn(tree, 16384);
        col3.setText(Messages.getString("TableDefineEditor.5"));
        col3.setWidth(500);
        col3.setResizable(true);
        TreeColumn col4 = new TreeColumn(tree, 0x1000000);
        col4.setText(Messages.getString("TableDefineEditor.6"));
        col4.setWidth(500);
        col4.setResizable(true);
    }

    public void createTableDefineWidget(Composite comp) {
        this.defineViewer = new TableViewer(comp, 67588);
        GridData gd = new GridData(1808);
        this.table = this.defineViewer.getTable();
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setFont(DbPlugin.getDefaultFont());
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TableDefineEditor.this.setFocusDefine(true);
            }

            public void focusLost(FocusEvent e) {
                TableDefineEditor.this.table.deselectAll();
            }
        });
        this.defineViewer.setContentProvider((IContentProvider)new ColumnContentProvider());
        this.defineViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider());
        this.defineViewer.setSorter((ViewerSorter)new TreeViewSorter());
        this.setHeaderColumn(this.table);
        this.defineViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                switch (DBType.getType(TableDefineEditor.this.tableNode.getDbConfig())) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 12: {
                        int editIndex = TableDefineEditor.this.table.getSelectionIndex();
                        if (editIndex < 0) break;
                        TableItem tableItem = TableDefineEditor.this.table.getItem(editIndex);
                        Column col = (Column)tableItem.getData();
                        Shell shell = DbPlugin.getDefault().getShell();
                        ColumnWizard wizard = new ColumnWizard(TableDefineEditor.this.factory, TableDefineEditor.this.tableNode, col, false);
                        WizardDialog dialog2 = new WizardDialog(shell, (IWizard)wizard);
                        int n = dialog2.open();
                        break;
                    }
                    default: {
                        DbPlugin.getDefault().showWarningMessage(Messages.getString("TableDefineEditor.7"));
                    }
                }
            }
        });
    }

    private void columnsPack(Tree tree) {
        tree.setVisible(false);
        TreeColumn[] cols = tree.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            cols[i].setWidth(cols[i].getWidth() + 10);
            ++i;
        }
        tree.setVisible(true);
    }

    private void setHeaderColumn(Table table) {
        TableColumn dummy = new TableColumn(table, 0);
        dummy.setWidth(0);
        dummy.setResizable(false);
        TableColumn col1 = new TableColumn(table, 0);
        col1.setText(Messages.getString("TableDefineEditor.8"));
        col1.setWidth(150);
        TableColumn col2 = new TableColumn(table, 0);
        col2.setText(Messages.getString("TableDefineEditor.9"));
        col2.setWidth(120);
        TableColumn col3 = new TableColumn(table, 0x1000000);
        col3.setText(Messages.getString("TableDefineEditor.10"));
        col3.setWidth(50);
        TableColumn col4 = new TableColumn(table, 0);
        col4.setText(Messages.getString("TableDefineEditor.11"));
        col4.setWidth(100);
        TableColumn col5 = new TableColumn(table, 0);
        col5.setText(Messages.getString("TableDefineEditor.12"));
        col5.setWidth(200);
    }

    private void columnsPack(Table table) {
        table.setVisible(false);
        TableColumn[] cols = table.getColumns();
        cols[1].pack();
        cols[2].pack();
        cols[4].pack();
        cols[5].pack();
        table.setVisible(true);
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    public String getTableName() {
        return this.txtTableName.getText();
    }

    public String getTableComment() {
        return this.txtTableComment.getText();
    }

    public void setOrgTableName(String tableName) {
        this.orgTableName = tableName;
    }

    public void setOrgTableComment(String tableComment) {
        this.orgTableComment = tableComment;
    }

    public TreeViewer getConstraintViewer() {
        return this.constraintViewer;
    }

    public TableViewer getDefineViewer() {
        return this.defineViewer;
    }

    public boolean focusDefine() {
        return this.focusDefine;
    }

    public void setFocusDefine(boolean b) {
        this.focusDefine = b;
    }

    private class ColumnContentProvider
    implements IStructuredContentProvider {
        private ColumnContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Column[]) {
                return (Column[])inputElement;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ImageCacher imageCacher = ImageCacher.getInstance();

        private ColumnLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            Column col = (Column)element;
            switch (columnIndex) {
                case 0: {
                    result = "";
                    break;
                }
                case 1: {
                    result = col.getName().trim();
                    break;
                }
                case 2: {
                    StringBuffer typeStr = new StringBuffer();
                    typeStr.append(col.getTypeName());
                    if (col.isVisibleColumnSize() && !col.getColumn().isWithoutParam()) {
                        typeStr.append("(").append(col.getSize()).append(")");
                    }
                    result = typeStr.toString();
                    break;
                }
                case 3: {
                    result = "";
                    break;
                }
                case 4: {
                    result = col.getDefaultValue();
                    break;
                }
                case 5: {
                    result = col.getRemarks();
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Column col = (Column)element;
            if (columnIndex == 3) {
                return this.getCheckImage(col.isNotNull());
            }
            return null;
        }

        private Image getCheckImage(boolean isSelected) {
            String key = isSelected ? "checkedcenter.gif" : "uncheckedcenter.gif";
            return this.imageCacher.getImage(key);
        }

        public String getText(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    private class ConstraintAndIndexContentProvider
    implements ITreeContentProvider {
        private ConstraintAndIndexContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreeNode) {
                TreeNode model = (TreeNode)parentElement;
                return model.getChildrens();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof TreeNode) {
                TreeNode model = (TreeNode)element;
                return model.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ConstraintAndIndexLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ConstraintAndIndexLabelProvider() {
        }

        public String getColumnText(Object obj, int i) {
            block24: {
                block25: {
                    block23: {
                        if (!(obj instanceof ConstraintRoot)) break block23;
                        ConstraintRoot root = (ConstraintRoot)obj;
                        switch (i) {
                            case 0: {
                                return root.getName();
                            }
                        }
                        return "";
                    }
                    if (obj instanceof Constraint) {
                        Constraint constraint = (Constraint)obj;
                        switch (i) {
                            case 0: {
                                return constraint.getName();
                            }
                            case 1: {
                                return constraint.getType();
                            }
                            case 2: {
                                return constraint.getParamater();
                            }
                        }
                        break block24;
                    }
                    if (!(obj instanceof IndexRoot)) break block25;
                    IndexRoot root = (IndexRoot)obj;
                    switch (i) {
                        case 0: {
                            return root.getName();
                        }
                    }
                    return "";
                }
                try {
                    if (obj instanceof Index) {
                        Index idx = (Index)obj;
                        switch (i) {
                            case 0: {
                                return idx.getName();
                            }
                            case 1: {
                                return idx.getType();
                            }
                            case 2: {
                                return idx.getParamater();
                            }
                            case 3: {
                                return idx.getIndexType();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 0) {
                return this.getImage(obj);
            }
            return null;
        }

        public Image getImage(Object obj) {
            if (obj instanceof Constraint) {
                Constraint constraint = (Constraint)obj;
                if (constraint.getType().equals("PRIMARY KEY")) {
                    return TableDefineEditor.this.ic.getImage("primarykey.gif");
                }
                return null;
            }
            return null;
        }
    }
}

