/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.PatternUtil;
import zigen.plugin.db.ui.actions.AutoDelayListener;
import zigen.plugin.db.ui.editors.Messages;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.editors.internal.ColumnFilterInfo;
import zigen.plugin.db.ui.jobs.RecordSearchJob;
import zigen.plugin.db.ui.jobs.TableFilterJob;

public class ColumnFilterDialog
extends Dialog {
    private TableViewEditorFor31 editor;
    private TableViewer columnTableViewer;
    private int currentSortNumber = 0;
    private static final int BUTTON_ID_SELECTALL = -100;
    private static final int BUTTON_ID_REMOVEALL = -101;
    private static final String[] headers = new String[]{"", Messages.getString("ColumnFilterDialog.4"), Messages.getString("ColumnFilterDialog.14"), Messages.getString("ColumnFilterDialog.13"), Messages.getString("ColumnFilterDialog.5"), Messages.getString("ColumnFilterDialog.6"), Messages.getString("ColumnFilterDialog.7"), Messages.getString("ColumnFilterDialog.8"), Messages.getString("ColumnFilterDialog.9"), Messages.getString("ColumnFilterDialog.10"), Messages.getString("ColumnFilterDialog.11")};
    Button visibleCheck;
    Text filterText;
    Button regularExpressions;
    Button caseSensitive;
    boolean isFilterPattern;
    String filterPattern;

    public ColumnFilterDialog(Shell parent, TableViewEditorFor31 editor) {
        super(parent);
        Dialog.setDefaultImage((Image)ImageCacher.getInstance().getImage("db.gif"));
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.editor = editor;
        this.initialized(editor.filterInfos);
    }

    private void initialized(ColumnFilterInfo[] infos) {
        TreeMap<Integer, ColumnFilterInfo> map = new TreeMap<Integer, ColumnFilterInfo>();
        int i = 0;
        while (i < infos.length) {
            int sortNum = infos[i].getSortNo();
            if (sortNum > 0) {
                map.put(new Integer(sortNum), infos[i]);
            }
            ++i;
        }
        int cnt = 0;
        for (Integer key : map.keySet()) {
            ColumnFilterInfo info = (ColumnFilterInfo)map.get(key);
            info.setSortNo(++cnt);
        }
        this.currentSortNumber = cnt;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ColumnFilterDialog.0"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -100, Messages.getString("ColumnFilterDialog.1"), false);
        this.createButton(parent, -101, Messages.getString("ColumnFilterDialog.2"), false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean close() {
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.setReturnCode(buttonId);
            this.close();
        } else if (buttonId == 0) {
            RecordSearchJob job1 = new RecordSearchJob(this.editor, this.editor.getCondition(), this.editor.getOrderByString(), this.editor.offset, this.editor.limit);
            job1.setPriority(20);
            job1.setUser(true);
            job1.schedule();
            try {
                job1.join();
            }
            catch (InterruptedException e) {
                DbPlugin.log(e);
            }
            TableFilterJob job = new TableFilterJob(this.editor.getViewer(), this.editor.filterInfos);
            job.setPriority(20);
            job.setUser(false);
            job.schedule();
        } else if (buttonId == -100) {
            this.selectAllHandler();
        } else if (buttonId == -101) {
            this.removeAllHandler();
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite innerPanel1 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        innerPanel1.setLayout((Layout)gridLayout);
        GridData data = new GridData(768);
        innerPanel1.setLayoutData((Object)data);
        this.visibleCheck = new Button(innerPanel1, 32);
        this.visibleCheck.setText(Messages.getString("ColumnFilterDialog.18"));
        this.visibleCheck.setSelection(false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.visibleCheck.setLayoutData((Object)data);
        this.visibleCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnFilterDialog.this.visibleCheck.getSelection()) {
                    ColumnFilterDialog.this.filterText.setEnabled(true);
                    ColumnFilterDialog.this.regularExpressions.setEnabled(true);
                    ColumnFilterDialog.this.caseSensitive.setEnabled(true);
                    ColumnFilterDialog.this.filter(ColumnFilterDialog.this.filterText.getText());
                } else {
                    ColumnFilterDialog.this.filterText.setEnabled(false);
                    ColumnFilterDialog.this.regularExpressions.setEnabled(false);
                    ColumnFilterDialog.this.caseSensitive.setEnabled(false);
                    ColumnFilterDialog.this.filter("");
                }
                ColumnFilterDialog.this.isFilterPattern = ColumnFilterDialog.this.visibleCheck.getSelection();
            }
        });
        this.filterText = new Text(innerPanel1, 2052);
        this.filterText.setEnabled(false);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.filterText.setLayoutData((Object)data);
        this.filterText.addFocusListener((FocusListener)new TextSelectionListener());
        this.filterText.setFont(DbPlugin.getDefaultFont());
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
            }
        });
        this.filterText.addKeyListener((KeyListener)new AutoDelayFilterListener());
        Composite innerPanel2 = new Composite(composite, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        innerPanel2.setLayout((Layout)gridLayout);
        data = new GridData(768);
        innerPanel2.setLayoutData((Object)data);
        final Label label = new Label(innerPanel2, 0);
        label.setText(Messages.getString("ColumnFilterDialog.23"));
        data = new GridData(768);
        label.setLayoutData((Object)data);
        this.regularExpressions = new Button(innerPanel2, 32);
        this.regularExpressions.setEnabled(false);
        this.regularExpressions.setText(Messages.getString("ColumnFilterDialog.16"));
        this.regularExpressions.setSelection(false);
        data = new GridData();
        this.regularExpressions.setLayoutData((Object)data);
        this.regularExpressions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                label.setVisible(!ColumnFilterDialog.this.regularExpressions.getSelection());
            }
        });
        this.caseSensitive = new Button(innerPanel2, 32);
        this.caseSensitive.setEnabled(false);
        this.caseSensitive.setText(Messages.getString("ColumnFilterDialog.17"));
        this.caseSensitive.setSelection(false);
        data = new GridData();
        data.horizontalAlignment = 3;
        this.caseSensitive.setLayoutData((Object)data);
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayout((Layout)new GridLayout(1, false));
        data = new GridData(1808);
        data.heightHint = 400;
        tableComposite.setLayoutData((Object)data);
        this.columnTableViewer = new TableViewer(tableComposite, 68352);
        this.columnTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        Label label3 = new Label(tableComposite, 0);
        label3.setText(Messages.getString("ColumnFilterDialog.12"));
        data = new GridData(768);
        label3.setLayoutData((Object)data);
        Table table = this.columnTableViewer.getTable();
        table.setFont(DbPlugin.getDefaultFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setHeaderColumn(table, headers);
        this.columnTableViewer.setColumnProperties(new String[]{"dummy", "check", "sort", "sort", "check", "check", "check", "check", "check", "check", "check"});
        CheckboxCellEditor checkEditor = new CheckboxCellEditor((Composite)table);
        CheckboxCellEditor checkEditor2 = new CheckboxCellEditor((Composite)table);
        CellEditor[] cellEditorArray = new CellEditor[11];
        cellEditorArray[1] = checkEditor;
        cellEditorArray[2] = checkEditor2;
        cellEditorArray[3] = checkEditor2;
        CellEditor[] editors = cellEditorArray;
        this.columnTableViewer.setCellEditors(editors);
        this.columnTableViewer.setCellModifier((ICellModifier)new ColumnSelectCellModifier());
        this.columnTableViewer.setLabelProvider((IBaseLabelProvider)new ColumnSelectLabelProvider());
        this.columnTableViewer.setContentProvider((IContentProvider)new ColumnSelectContentProvider());
        this.columnTableViewer.setInput((Object)this.editor.filterInfos);
        this.columnsPack(table);
        this.filterPattern = this.editor.filterPattern == null ? "" : this.editor.filterPattern;
        this.filterText.setText(this.filterPattern);
        this.visibleCheck.setSelection(this.editor.checkFilterPattern);
        if (this.visibleCheck.getSelection()) {
            this.filterText.setEnabled(true);
            this.regularExpressions.setEnabled(true);
            this.caseSensitive.setEnabled(true);
        } else {
            this.filterText.setEnabled(false);
            this.regularExpressions.setEnabled(false);
            this.caseSensitive.setEnabled(false);
        }
        this.isFilterPattern = this.visibleCheck.getSelection();
        return composite;
    }

    private void selectAllHandler() {
        int i = 0;
        while (i < this.columnTableViewer.getTable().getItemCount()) {
            ColumnFilterInfo info = (ColumnFilterInfo)this.columnTableViewer.getElementAt(i);
            info.setChecked(true);
            ++i;
        }
        this.columnTableViewer.refresh();
    }

    private void removeAllHandler() {
        int i = 0;
        while (i < this.columnTableViewer.getTable().getItemCount()) {
            ColumnFilterInfo info = (ColumnFilterInfo)this.columnTableViewer.getElementAt(i);
            if (info.isPrimaryKey()) {
                info.setChecked(true);
            } else {
                info.setChecked(false);
            }
            ++i;
        }
        this.columnTableViewer.refresh();
    }

    private void setHeaderColumn(Table table, String[] headers) {
        int i = 0;
        while (i < headers.length) {
            switch (i) {
                case 0: {
                    TableColumn col = new TableColumn(table, 0, i);
                    col.setText(headers[i]);
                    col.setResizable(false);
                    col.setWidth(0);
                    break;
                }
                case 1: {
                    TableColumn col = new TableColumn(table, 0x1000000, i);
                    col.setText(headers[i]);
                    col.setResizable(false);
                    col.setWidth(50);
                    break;
                }
                case 2: {
                    TableColumn col = new TableColumn(table, 0, i);
                    col.setText(headers[i]);
                    col.setResizable(false);
                    col.setWidth(50);
                    break;
                }
                case 3: {
                    TableColumn col = new TableColumn(table, 0x1000000, i);
                    col.setText(headers[i]);
                    col.setResizable(false);
                    col.setWidth(50);
                    break;
                }
                case 7: 
                case 8: {
                    TableColumn col = new TableColumn(table, 0x1000000, i);
                    col.setText(headers[i]);
                    col.setResizable(true);
                    col.pack();
                    break;
                }
                default: {
                    TableColumn col = new TableColumn(table, 16384, i);
                    col.setText(headers[i]);
                    col.setResizable(true);
                    col.pack();
                }
            }
            ++i;
        }
    }

    private void columnsPack(Table table) {
        table.setVisible(false);
        TableColumn[] cols = table.getColumns();
        int i = 3;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
        table.setVisible(true);
    }

    private void updateAll() {
        Object[] infos = this.editor.filterInfos;
        TreeMap<Integer, ColumnFilterInfo> map = new TreeMap<Integer, ColumnFilterInfo>();
        int i = 0;
        while (i < infos.length) {
            int sortNum = infos[i].getSortNo();
            if (sortNum > 0) {
                map.put(new Integer(sortNum), infos[i]);
            }
            ++i;
        }
        int cnt = 0;
        for (Integer key : map.keySet()) {
            ColumnFilterInfo info = (ColumnFilterInfo)map.get(key);
            info.setSortNo(++cnt);
        }
        this.currentSortNumber = cnt;
        this.columnTableViewer.update(infos, new String[]{"sort"});
    }

    private void filter(String condition) {
        if (!this.visibleCheck.getSelection()) {
            return;
        }
        int i = 0;
        while (i < this.columnTableViewer.getTable().getItemCount()) {
            ColumnFilterInfo info = (ColumnFilterInfo)this.columnTableViewer.getElementAt(i);
            if (!info.isPrimaryKey()) {
                info.setChecked(this.filter(info, condition));
            } else {
                info.setChecked(true);
            }
            ++i;
        }
        this.columnTableViewer.refresh();
    }

    boolean filter(ColumnFilterInfo info, String text) {
        if (text != null && !"".equals(text)) {
            String columnName = info.getColumnName();
            String remarks = info.getCommentName();
            if (this.regularExpressions.getSelection()) {
                try {
                    Pattern pattern = null;
                    pattern = !this.caseSensitive.getSelection() ? Pattern.compile(text, 2) : Pattern.compile(text);
                    Matcher mc = pattern.matcher(columnName);
                    Matcher mc2 = pattern.matcher(remarks);
                    return mc.matches() || mc2.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            if (text != null && text.trim().length() > 0) {
                try {
                    Pattern pattern = PatternUtil.getPattern(text, this.caseSensitive.getSelection());
                    Matcher mc = pattern.matcher(columnName);
                    Matcher mc2 = pattern.matcher(remarks);
                    return mc.matches() || mc2.matches();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    class AutoDelayFilterListener
    extends AutoDelayListener {
        private static final int delayTime = 300;

        public AutoDelayFilterListener() {
            super(300);
        }

        public Runnable createExecutAction() {
            return new Runnable(){

                public void run() {
                    try {
                        ((AutoDelayFilterListener)AutoDelayFilterListener.this).ColumnFilterDialog.this.filterPattern = ((AutoDelayFilterListener)AutoDelayFilterListener.this).ColumnFilterDialog.this.filterText.getText();
                        ColumnFilterDialog.this.filter(((AutoDelayFilterListener)AutoDelayFilterListener.this).ColumnFilterDialog.this.filterPattern);
                    }
                    catch (Exception e) {
                        DbPlugin.log(e);
                    }
                }
            };
        }
    }

    private class ColumnSelectCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            ColumnFilterInfo item = (ColumnFilterInfo)element;
            if (property == "check") {
                return new Boolean(item.isChecked());
            }
            if (property == "sort") {
                return new Boolean(item.isChecked());
            }
            return item.getColumnName();
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            ColumnFilterInfo info = (ColumnFilterInfo)element;
            if (property == "check" && !info.isPrimaryKey()) {
                info.setChecked((Boolean)value);
                ColumnFilterDialog.this.columnTableViewer.update(element, new String[]{"check"});
            } else if (property == "sort") {
                int current = info.getSortNo();
                if (current == 0) {
                    ColumnFilterDialog columnFilterDialog = ColumnFilterDialog.this;
                    int n = columnFilterDialog.currentSortNumber + 1;
                    columnFilterDialog.currentSortNumber = n;
                    info.setSortNo(n);
                    info.setDesc(false);
                    ColumnFilterDialog.this.columnTableViewer.update(element, new String[]{"sort"});
                } else if (!info.isDesc()) {
                    info.setDesc(true);
                    ColumnFilterDialog.this.columnTableViewer.update(element, new String[]{"sort"});
                } else if (info.isDesc()) {
                    info.setSortNo(0);
                    ColumnFilterDialog.this.updateAll();
                }
            }
        }
    }

    private class ColumnSelectContentProvider
    implements IStructuredContentProvider {
        private List contents = null;

        private ColumnSelectContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ColumnFilterInfo[]) {
                return (ColumnFilterInfo[])inputElement;
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.contents = null;
        }

        public void dispose() {
            this.contents = null;
        }
    }

    private class ColumnSelectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ImageCacher imageCacher = ImageCacher.getInstance();

        private ColumnSelectLabelProvider() {
        }

        private Image getImage(boolean isSelected) {
            String key = isSelected ? "checkedcenter.gif" : "uncheckedcenter.gif";
            return this.imageCacher.getImage(key);
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            ColumnFilterInfo col = (ColumnFilterInfo)element;
            switch (columnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    result = col.getSortNo() == 0 ? "" : String.valueOf(col.getSortNo());
                    break;
                }
                case 4: {
                    result = col.getColumnName();
                    break;
                }
                case 5: {
                    result = col.getTypeName().toUpperCase();
                    break;
                }
                case 6: {
                    result = col.getSize();
                    break;
                }
                case 7: {
                    result = col.isPrimaryKey() ? "\u25cb" : "\u3000";
                    break;
                }
                case 8: {
                    result = col.isNotNull() ? "\u25cb" : "\u3000";
                    break;
                }
                case 9: {
                    result = col.getDefaultValue();
                    break;
                }
                case 10: {
                    result = col.getCommentName();
                    break;
                }
            }
            return result;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ColumnFilterInfo info = (ColumnFilterInfo)element;
            if (columnIndex == 1) {
                if (!info.isPrimaryKey()) {
                    return this.getImage(info.isChecked());
                }
                return this.imageCacher.getImage("disabledcheckedcenter.gif");
            }
            if (columnIndex == 2) {
                if (info.getSortNo() == 0) {
                    return this.imageCacher.getImage("dummy.gif");
                }
                if (info.isDesc()) {
                    return this.imageCacher.getImage("desc.gif");
                }
                return this.imageCacher.getImage("asc.gif");
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }
    }
}

