/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.SourceViewer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLTokenizer;
import zigen.plugin.db.core.TimeWatcher;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.views.SQLExecuteView;

public class SQLFormatAction
extends Action
implements Runnable {
    private SQLExecuteView view;

    public SQLFormatAction(SQLExecuteView view) {
        this.setText(Messages.getString("SQLFormatAction.0"));
        this.setToolTipText(Messages.getString("SQLFormatAction.1"));
        this.setActionDefinitionId("zigen.plugin.SQLFormatActionCommand");
        this.setImageDescriptor(DbPlugin.getDefault().getImageRegistry().getDescriptor("format.gif"));
        this.view = view;
    }

    public void run() {
        TimeWatcher tw = new TimeWatcher();
        try {
            try {
                SourceViewer sv = this.view.getSqlViewer();
                String preSql = sv.getDocument().get();
                StringBuffer sb = new StringBuffer();
                IPreferenceStore store = DbPlugin.getDefault().getPreferenceStore();
                String demiliter = store.getString("SQLEditorPreferencePage.SqlDemiliter");
                boolean onPatch = DbPlugin.getDefault().getPreferenceStore().getBoolean("SQLEditorPreferencePage.FormatPatch");
                int type = DbPlugin.getDefault().getPreferenceStore().getInt("SQLFormatPreferencePage.UseFormatterType");
                tw.start();
                SQLTokenizer st = new SQLTokenizer(preSql, demiliter);
                while (st.hasMoreElements()) {
                    String sql = (String)st.nextElement();
                    if (sql == null || sql.length() <= 0) continue;
                    sb.append(SQLFormatter.format(sql, type, onPatch));
                    if ("/".equals(demiliter)) {
                        sb.append(DbPluginConstant.LINE_SEP);
                    }
                    sb.append(demiliter);
                    sb.append(DbPluginConstant.LINE_SEP);
                }
                sv.getDocument().set(sb.toString());
                tw.stop();
                this.view.setStatusMessage("Complete SQL Format. " + tw.getTotalTime());
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
                if (tw != null && tw.isStart()) {
                    tw.stop();
                }
            }
        }
        finally {
            if (tw != null && tw.isStart()) {
                tw.stop();
            }
        }
    }
}

