/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.SQLInvoker;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.internal.ITable;

public class RenameTableAction
extends Action
implements Runnable {
    private StructuredViewer viewer = null;
    private IDBConfig config;
    private ISQLCreatorFactory factory;

    public RenameTableAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("RenameTableAction.0"));
        this.setToolTipText(Messages.getString("RenameTableAction.1"));
    }

    public void run() {
        Object element = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        try {
            if (element instanceof ITable) {
                ITable table = (ITable)element;
                Shell shell = DbPlugin.getDefault().getShell();
                InputDialog dialog = new InputDialog(shell, Messages.getString("RenameTableAction.2"), Messages.getString("RenameTableAction.3"), table.getName(), null);
                int rc = dialog.open();
                if (rc == 1) {
                    return;
                }
                String newTableName = dialog.getValue().trim();
                if (!table.getName().equals(newTableName)) {
                    String newRemarks = table.getRemarks();
                    this.config = table.getDbConfig();
                    this.factory = AbstractSQLCreatorFactory.getFactory(this.config, table);
                    Transaction trans = Transaction.getInstance(this.config);
                    String[] sqls = this.createSQL(table, newTableName, newRemarks);
                    int i = 0;
                    while (i < sqls.length) {
                        SQLInvoker.execute(trans.getConnection(), sqls[i]);
                        ++i;
                    }
                    if (!this.config.isAutoCommit() && this.factory.supportsRollbackDDL() && DbPlugin.getDefault().confirmDialog(Messages.getString("RenameTableAction.4"))) {
                        trans.commit();
                    }
                    DbPlugin.fireStatusChangeListener(table, 103);
                    table.setName(newTableName);
                    this.viewer.refresh((Object)table);
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public String[] createSQL(ITable table, String newTableName, String newRemarks) {
        ArrayList<String> list = new ArrayList<String>();
        if (!table.getRemarks().equals(newRemarks)) {
            list.add(this.factory.createCommentOnTableDDL(newRemarks));
        }
        if (!table.getName().equals(newTableName)) {
            list.add(this.factory.createRenameTableDDL(newTableName));
        }
        return list.toArray(new String[0]);
    }
}

