/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.IDocument;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceErrorInfo;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.editors.sql.IPlsqlEditor;
import zigen.plugin.db.ui.jobs.ScriptExecJob;

public class ExecuteScriptAction
extends Action
implements Runnable {
    private boolean editorMode = false;
    private IDBConfig config;
    private String secondaryId;
    private IDocument doc;
    private IPlsqlEditor plsqlEditor;

    public ExecuteScriptAction(IDBConfig config, IDocument doc, String secondaryId) {
        super.setText(Messages.getString("ExecuteScriptAction.0"));
        super.setToolTipText(Messages.getString("ExecuteScriptAction.1"));
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("script.gif"));
        this.config = config;
        this.doc = doc;
        this.secondaryId = secondaryId;
    }

    public ExecuteScriptAction(IPlsqlEditor plsqlEditor) {
        super.setText(Messages.getString("ExecuteScriptAction.0"));
        super.setToolTipText(Messages.getString("ExecuteScriptAction.1"));
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("script.gif"));
        this.config = plsqlEditor.getConfig();
        this.editorMode = true;
        this.doc = plsqlEditor.getPLSQLSourceViewer().getDocument();
        this.secondaryId = null;
        this.plsqlEditor = plsqlEditor;
    }

    public void run() {
        block6: {
            try {
                if (this.config == null) break block6;
                String sql = this.doc.get();
                if (sql != null && sql.trim().length() > 0) {
                    Transaction trans = Transaction.getInstance(this.config);
                    ScriptExecJob job = new ScriptExecJob(trans, sql, this.secondaryId);
                    job.setUser(false);
                    job.schedule();
                    if (!this.editorMode) break block6;
                    try {
                        job.join();
                        this.plsqlEditor.clearError();
                        OracleSourceErrorInfo[] errs = job.getOracleSourceErrorInfos();
                        if (errs != null) {
                            this.plsqlEditor.setError(errs);
                        }
                        break block6;
                    }
                    catch (InterruptedException e) {
                        DbPlugin.log(e);
                    }
                    break block6;
                }
                DbPlugin.getDefault().showInformationMessage(Messages.getString("ExecuteScriptAction.2"));
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
            }
        }
    }
}

