/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.internal.ColumnFilterInfo;

public class CopyRecordDataAction
extends TableViewEditorAction {
    private final String LINE_SEP = System.getProperty("line.separator");
    private final String DEMILITER = "\t";
    protected IStructuredSelection selection;

    public CopyRecordDataAction() {
        this.setEnabled(false);
        this.setImage(4);
    }

    private boolean isVisibled(int columnIndex) {
        if (this.editor instanceof TableViewEditorFor31) {
            TableViewEditorFor31 editor31 = (TableViewEditorFor31)this.editor;
            ColumnFilterInfo[] filters = editor31.getFilterInfos();
            return filters[columnIndex].isChecked();
        }
        return true;
    }

    public void run() {
        try {
            try {
                StringBuffer sb = new StringBuffer();
                Clipboard clipboard = ClipboardUtils.getInstance();
                IStructuredSelection selection = (IStructuredSelection)this.editor.getViewer().getSelection();
                Iterator iter = selection.iterator();
                int index = 0;
                while (iter.hasNext()) {
                    Object obj = iter.next();
                    if (!(obj instanceof TableElement)) continue;
                    TableElement elem = (TableElement)obj;
                    TableColumn[] columns = elem.getColumns();
                    if (index == 0) {
                        this.createHeader(sb, columns);
                    }
                    boolean isFirst = true;
                    int i = 0;
                    while (i < columns.length) {
                        if (this.isVisibled(i)) {
                            TableColumn col = columns[i];
                            col.getDataType();
                            String value = String.valueOf(elem.getItem(i));
                            if (value.indexOf("\"") >= 0) {
                                value = value.replaceAll("\"", "\"\"");
                            }
                            value = value.length() == 0 ? "\"\"" : value.replaceAll("^|$", "\"");
                            if (isFirst) {
                                sb.append(value);
                                isFirst = false;
                            } else {
                                sb.append("\t" + value);
                            }
                        }
                        ++i;
                    }
                    sb.append(this.LINE_SEP);
                    ++index;
                }
                clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (Exception e) {
                DbPlugin.getDefault().showErrorDialog(e);
                this.editor.getViewer().getControl().notifyListeners(13, null);
            }
        }
        finally {
            this.editor.getViewer().getControl().notifyListeners(13, null);
        }
    }

    private void createHeader(StringBuffer sb, TableColumn[] columns) {
        boolean isFirst = true;
        int i = 0;
        while (i < columns.length) {
            if (this.isVisibled(i)) {
                TableColumn col = columns[i];
                if (isFirst) {
                    sb.append(col.getColumnName());
                    isFirst = false;
                } else {
                    sb.append("\t" + col.getColumnName());
                }
            }
            ++i;
        }
        sb.append(this.LINE_SEP);
    }

    public void refresh() {
        if (this.editor == null) {
            this.setEnabled(false);
        } else if (this.editor.getViewer() == null) {
            this.setEnabled(false);
        } else {
            this.selection = (IStructuredSelection)this.editor.getViewer().getSelection();
            if (this.selection.size() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        IStructuredSelection _selection = (IStructuredSelection)this.editor.getViewer().getSelection();
        if (_selection != null && _selection.size() > 0) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

