/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.ui.actions.AbstractCopyAction;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class CopyLogicalColumnNameWithTableNameAction
extends AbstractCopyAction {
    public void run(IAction action) {
        try {
            StringBuffer sb = new StringBuffer();
            Clipboard clipboard = ClipboardUtils.getInstance();
            int index = 0;
            for (Object obj : this.selection) {
                String remarks;
                if (!(obj instanceof Column)) continue;
                Column col = (Column)obj;
                ITable table = col.getTable();
                String tableRemarks = table.getRemarks();
                if (tableRemarks == null || "".equals(tableRemarks.trim())) {
                    tableRemarks = table.getName();
                }
                if ((remarks = col.getRemarks()) == null || "".equals(remarks.trim())) {
                    remarks = col.getName();
                }
                if (index == 0) {
                    sb.append(tableRemarks);
                    sb.append(".");
                    sb.append(remarks);
                } else {
                    sb.append(", ");
                    sb.append(tableRemarks);
                    sb.append(".");
                    sb.append(remarks);
                }
                ++index;
            }
            clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

