/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.views.ColumnSearchAction;
import zigen.plugin.db.ui.views.TreeView;

public class CopyCreateStatementAction
implements IViewActionDelegate {
    private ISelection selection = null;
    private IViewPart viewPart;
    TreeViewer treeViewer;
    boolean isSelectedColumn = false;
    StringBuffer sb = null;

    public void init(IViewPart view) {
        this.viewPart = view;
        if (view instanceof TreeView) {
            this.treeViewer = ((TreeView)view).getTreeViewer();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(IAction action) {
        try {
            if (!(this.selection instanceof IStructuredSelection)) return;
            IStructuredSelection ss = (IStructuredSelection)this.selection;
            new StringBuffer();
            if (!this.checkLoadColumn(ss)) {
                String msg = "\u30ab\u30e9\u30e0\u60c5\u5831\u304c\u672a\u53d6\u5f97\u306e\u30c6\u30fc\u30d6\u30eb\u304c\u3042\u308a\u307e\u3059\u3002\u53d6\u5f97\u3057\u307e\u3059\u304b\uff1f";
                msg = String.valueOf(msg) + "\n\u30ab\u30e9\u30e0\u60c5\u5831\u306e\u53d6\u5f97\u306b\u306f\u6642\u9593\u304c\u304b\u304b\u308b\u5834\u5408\u304c\u3042\u308a\u307e\u3059\u3002";
                if (!DbPlugin.getDefault().confirmDialog(msg)) return;
                new LoadAction((StructuredViewer)this.treeViewer, ss).run();
                return;
            } else {
                new LoadAction((StructuredViewer)this.treeViewer, ss).run();
            }
            return;
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private boolean checkLoadColumn(IStructuredSelection ss) {
        for (Object obj : ss) {
            ITable table;
            if (!(obj instanceof ITable) || (table = (ITable)obj).isExpanded()) continue;
            return false;
        }
        return true;
    }

    private String getCommentStatement(ITable tableNode) {
        StringBuffer sb = new StringBuffer();
        if (tableNode != null) {
            IDBConfig config = tableNode.getDbConfig();
            ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactoryNoCache(config, tableNode);
            factory.setVisibleSchemaName(false);
            sb.append(factory.getTableComment());
            sb.append(factory.getColumnComment());
        }
        return sb.toString();
    }

    void setContents(String contents) {
        Clipboard clipboard = ClipboardUtils.getInstance();
        if (contents.length() > 0) {
            clipboard.setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    class LoadAction
    extends Action {
        IStructuredSelection ss;
        StructuredViewer viewer;

        public LoadAction(StructuredViewer viewer, IStructuredSelection ss) {
            this.viewer = viewer;
            this.ss = ss;
        }

        public void run() {
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("\u30ab\u30e9\u30e0\u60c5\u5831\u306e\u53d6\u5f97\u4e2d...", LoadAction.this.ss.size());
                        ((LoadAction)LoadAction.this).CopyCreateStatementAction.this.sb = new StringBuffer();
                        int i = 1;
                        Iterator iter = LoadAction.this.ss.iterator();
                        while (iter.hasNext()) {
                            if (monitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            Object obj = iter.next();
                            if (obj instanceof ITable) {
                                ITable table = (ITable)obj;
                                monitor.subTask("Target : " + table + ", " + i + "/" + LoadAction.this.ss.size());
                                if (!table.isExpanded()) {
                                    table.setExpanded(true);
                                    new ColumnSearchAction(LoadAction.this.viewer, table).run();
                                }
                                ((LoadAction)LoadAction.this).CopyCreateStatementAction.this.sb.append(CopyCreateStatementAction.this.getCommentStatement(table));
                            }
                            monitor.worked(1);
                            ++i;
                        }
                        monitor.done();
                        CopyCreateStatementAction.this.setContents(((LoadAction)LoadAction.this).CopyCreateStatementAction.this.sb.toString());
                    }
                };
                new ProgressMonitorDialog(DbPlugin.getDefault().getShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                DbPlugin.getDefault().showInformationMessage("\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f");
            }
        }
    }
}

