/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.actions;

import org.eclipse.jface.text.IDocument;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.parser.util.CurrentSql;
import zigen.plugin.db.ui.actions.Messages;
import zigen.plugin.db.ui.actions.SQLSourceViewerAction;
import zigen.plugin.db.ui.jobs.SqlExecJob;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public abstract class AbstractExecuteSQLAction
extends SQLSourceViewerAction
implements Runnable {
    private static int MAX_BYTES_SIZE = 0x100000;
    protected IDBConfig config;
    protected IDocument doc;
    protected int offset;
    protected int viewer;
    protected String secondaryId;

    public AbstractExecuteSQLAction(IDBConfig config, SQLSourceViewer viewer, String secondaryId) {
        super(viewer);
        this.config = config;
        this.doc = viewer.getDocument();
        this.offset = viewer.getTextWidget().getCaretOffset();
        this.secondaryId = secondaryId;
        this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("execute.gif"));
    }

    protected String getDemiliter() {
        return DbPlugin.getDefault().getPreferenceStore().getString("SQLEditorPreferencePage.SqlDemiliter");
    }

    protected String getAllSql() {
        return this.doc.get();
    }

    protected String getCurrentSql() {
        String demiliter = this.getDemiliter();
        return new CurrentSql(this.doc, this.offset, demiliter).getSql();
    }

    protected void executeSql(String sql) {
        if (sql != null && sql.trim().length() > 0) {
            Transaction trans = Transaction.getInstance(this.config);
            SqlExecJob job = new SqlExecJob(trans, sql, this.secondaryId);
            job.setPriority(10);
            job.setUser(false);
            job.schedule();
        } else {
            DbPlugin.getDefault().showInformationMessage(Messages.getString("AbstractExecuteSQLAction.Message"));
        }
    }
}

