/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.preference;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.preference.Messages;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;

public class URLInputDialog
extends Dialog {
    private static final int LEVEL_FIELD_WIDTH = 20;
    private static final int TEXT_FIELD_WIDTH = 50;
    protected Text driverText;
    protected Text urlText;
    protected static final String KEY_DRIVER = "driver";
    protected static final String KEY_URL = "url";
    protected Map valueMap = new HashMap();

    public String getStringValue(String key) {
        return (String)this.valueMap.get(key);
    }

    public void setStringValue(String key, String value) {
        this.valueMap.put(key, value);
    }

    public URLInputDialog(Shell parent) {
        super(parent);
    }

    protected void okPressed() {
        if (this.save()) {
            super.okPressed();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("URLInputDialog.2"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        this.addDriverSection(composite);
        this.addURLSection(composite);
        return composite;
    }

    private String validate(String fieldName, Text text) {
        String value = text.getText();
        if (value == null || value.length() == 0) {
            text.setFocus();
            return String.valueOf(fieldName) + Messages.getString("URLInputDialog.3");
        }
        if (value.indexOf(",") > 0 || value.indexOf("|") > 0) {
            text.setFocus();
            return String.valueOf(fieldName) + Messages.getString("URLInputDialog.6");
        }
        return null;
    }

    private boolean save() {
        String msg = null;
        msg = this.validate("Driver", this.driverText);
        if (msg != null) {
            DbPlugin.getDefault().showWarningMessage(msg);
            return false;
        }
        msg = this.validate("URL", this.urlText);
        if (msg != null) {
            DbPlugin.getDefault().showWarningMessage(msg);
            return false;
        }
        this.valueMap.put(KEY_DRIVER, this.driverText.getText());
        this.valueMap.put(KEY_URL, this.urlText.getText());
        return true;
    }

    private void addDriverSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("URLInputDialog.9"));
        nameLabel.setLayoutData((Object)this.getGridData(20));
        this.driverText = new Text(composite, 2052);
        this.driverText.setLayoutData((Object)this.getGridData(50));
        this.driverText.addFocusListener((FocusListener)new TextSelectionListener());
        this.driverText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                URLInputDialog.this.verifyHandler(e);
            }
        });
        if (this.valueMap.containsKey(KEY_DRIVER)) {
            this.driverText.setText(this.getStringValue(KEY_DRIVER));
        }
    }

    private void addURLSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.getString("URLInputDialog.10"));
        nameLabel.setLayoutData((Object)this.getGridData(20));
        this.urlText = new Text(composite, 2052);
        this.urlText.setLayoutData((Object)this.getGridData(50));
        this.urlText.addFocusListener((FocusListener)new TextSelectionListener());
        this.urlText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                URLInputDialog.this.verifyHandler(e);
            }
        });
        if (this.valueMap.containsKey(KEY_URL)) {
            this.urlText.setText(this.getStringValue(KEY_URL));
        }
    }

    protected Point getInitialSize() {
        return new Point(400, 150);
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    private GridData getGridData(int width) {
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(width);
        return gd;
    }

    public void verifyHandler(VerifyEvent event) {
        if (event.character == ',' || event.character == '|') {
            event.doit = false;
        }
    }

    public void validateHandler(TypedEvent event) {
        Text text = (Text)event.widget;
        String value = text.getText();
        if (value.indexOf(",") > 0 || value.indexOf("|") > 0) {
            text.setFocus();
        }
    }
}

