/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.tablespace;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleIndexColumnSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleIndexNameSearcher;
import zigen.plugin.db.ext.oracle.tablespace.CalcIndexSpace;
import zigen.plugin.db.ext.oracle.tablespace.CalcTableSpaceException;
import zigen.plugin.db.ext.oracle.tablespace.OracleIndexColumn;
import zigen.plugin.db.ui.internal.Table;

public class CalcIndexSpaces {
    private Table table;
    private int dbBlockSize;
    private int pctFree;
    private long maxRecord;
    private CalcIndexSpace[] calcIndexSpaces = null;

    public CalcIndexSpaces(Table table, int pctFree, long maxRecord) {
        this.table = table;
        this.pctFree = pctFree;
        this.maxRecord = maxRecord;
    }

    public CalcIndexSpaces(Table table, int dbBlockSize, int pctFree, long maxRecord) {
        this.table = table;
        this.dbBlockSize = dbBlockSize;
        this.pctFree = pctFree;
        this.maxRecord = maxRecord;
    }

    public void calcurate() throws CalcTableSpaceException {
        try {
            IDBConfig config = this.table.getDbConfig();
            Connection con = Transaction.getInstance(config).getConnection();
            String[] indexes = OracleIndexNameSearcher.execute(con, this.table);
            ArrayList<CalcIndexSpace> wk = new ArrayList<CalcIndexSpace>();
            int i = 0;
            while (i < indexes.length) {
                OracleIndexColumn[] indexColumns = OracleIndexColumnSearcher.execute(con, this.table, indexes[i], config.isConvertUnicode());
                CalcIndexSpace calcIndexSpace = this.dbBlockSize > 0 ? new CalcIndexSpace(this.table, this.dbBlockSize, indexes[i], indexColumns, this.pctFree, this.maxRecord) : new CalcIndexSpace(this.table, indexes[i], indexColumns, this.pctFree, this.maxRecord);
                calcIndexSpace.calcurate();
                wk.add(calcIndexSpace);
                ++i;
            }
            this.calcIndexSpaces = wk.toArray(new CalcIndexSpace[0]);
        }
        catch (CalcTableSpaceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CalcTableSpaceException("\u8868\u9818\u57df\u306e\u898b\u7a4d\u308a\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e.getCause());
        }
    }

    public String getCalcResult() throws Exception {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.calcIndexSpaces.length) {
            CalcIndexSpace elem = this.calcIndexSpaces[i];
            sb.append(elem.getCalcResult());
            ++i;
        }
        return sb.toString();
    }

    public List getList() {
        ArrayList<List> elements = new ArrayList<List>(this.calcIndexSpaces.length);
        int i = 0;
        while (i < this.calcIndexSpaces.length) {
            elements.add(this.calcIndexSpaces[i].getCsvRow());
            ++i;
        }
        return elements;
    }

    public CalcIndexSpace[] getCalcIndexSpaces() {
        return this.calcIndexSpaces;
    }
}

