/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;

public class OracleSynonymInfoSearcher {
    public static SynonymInfo execute(IDBConfig config, String owner, String synonym) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleSynonymInfoSearcher.execute(con, owner, synonym);
    }

    public static SynonymInfo execute(Connection con, String owner, String synonym) throws Exception {
        SynonymInfo info = null;
        ResultSet rs = null;
        Statement st = null;
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleSynonymInfoSearcher.getSQL(owner, synonym));
                if (rs.next()) {
                    info = new SynonymInfo();
                    info.setSynonym_name(synonym);
                    info.setTable_owner(rs.getString("TABLE_OWNER"));
                    info.setTable_name(rs.getString("TABLE_NAME"));
                    info.setDb_link(rs.getString("DB_LINK"));
                    info.setComments(rs.getString("COMMENTS"));
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return info;
    }

    private static String getSQL(String owner, String synonym) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        S.TABLE_OWNER");
        sb.append("        ,S.TABLE_NAME");
        sb.append("        ,S.DB_LINK");
        sb.append("        ,T.COMMENTS");
        sb.append("    FROM");
        sb.append("        ALL_SYNONYMS S");
        sb.append("        ,ALL_TAB_COMMENTS T");
        sb.append("    WHERE");
        sb.append("        S.TABLE_OWNER = T.OWNER");
        sb.append("        AND S.TABLE_NAME = T.TABLE_NAME");
        sb.append("        AND S.OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("        AND S.SYNONYM_NAME = '" + SQLUtil.encodeQuotation(synonym) + "'");
        return sb.toString();
    }
}

