/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSourceInfo;

public class OracleSourceSearcher {
    public static OracleSourceInfo[] execute(IDBConfig config, String owner, String type) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleSourceSearcher.execute(con, owner, type);
    }

    public static OracleSourceInfo[] execute(Connection con, String owner, String type) throws Exception {
        ResultSet rs = null;
        Statement st = null;
        ArrayList<OracleSourceInfo> list = new ArrayList<OracleSourceInfo>();
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleSourceSearcher.getSQL(owner, type));
                while (rs.next()) {
                    OracleSourceInfo info = new OracleSourceInfo();
                    info.setOwner(rs.getString("OWNER"));
                    info.setName(rs.getString("NAME"));
                    info.setType(rs.getString("TYPE"));
                    list.add(info);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return list.toArray(new OracleSourceInfo[0]);
    }

    private static String getSQL(String owner, String type) {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         DISTINCT OWNER");
        sb.append("         ,NAME");
        sb.append("         ,TYPE");
        sb.append("     FROM");
        sb.append("         ALL_SOURCE");
        sb.append("     WHERE");
        sb.append("         OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("         AND TYPE = '" + SQLUtil.encodeQuotation(type) + "'");
        sb.append("     ORDER BY NAME");
        return sb.toString();
    }
}

