/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.OracleSequenceInfo;

public class OracleSequenceSearcher {
    public static OracleSequenceInfo[] execute(IDBConfig config, String owner) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return OracleSequenceSearcher.execute(con, owner);
    }

    public static OracleSequenceInfo[] execute(Connection con, String owner) throws Exception {
        ResultSet rs = null;
        Statement st = null;
        ArrayList<OracleSequenceInfo> list = new ArrayList<OracleSequenceInfo>();
        try {
            try {
                st = con.createStatement();
                rs = st.executeQuery(OracleSequenceSearcher.getSQL(owner));
                while (rs.next()) {
                    OracleSequenceInfo info = new OracleSequenceInfo();
                    int i = 0;
                    info.setSequece_owner(rs.getString(++i));
                    info.setSequence_name(rs.getString(++i));
                    info.setMin_value(rs.getBigDecimal(++i));
                    info.setMax_value(rs.getBigDecimal(++i));
                    info.setIncrement_by(rs.getBigDecimal(++i));
                    info.setCycle_flg(rs.getString(++i));
                    info.setOrder_flg(rs.getString(++i));
                    info.setCache_size(rs.getBigDecimal(++i));
                    info.setLast_number(rs.getBigDecimal(++i));
                    list.add(info);
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            ResultSetUtil.close(rs);
            StatementUtil.close(st);
            throw throwable;
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return list.toArray(new OracleSequenceInfo[0]);
    }

    private static String getSQL(String owner) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT");
        sb.append("        *");
        sb.append("    FROM");
        sb.append("        ALL_SEQUENCES");
        sb.append("    WHERE");
        sb.append("        SEQUENCE_OWNER = '" + SQLUtil.encodeQuotation(owner) + "'");
        sb.append("    ORDER BY");
        sb.append("        SEQUENCE_NAME");
        return sb.toString();
    }
}

