/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import zigen.plugin.db.ext.oracle.internal.OracleTypeSizeUtil;
import zigen.plugin.db.ext.oracle.tablespace.IColumn;

public class OracleColumnSizeUtil {
    private OracleTypeSizeUtil ts;

    public int getRowLength(Connection con, IColumn[] columns) throws Exception {
        this.ts = new OracleTypeSizeUtil(con);
        int a = this.ts.getInt("UB1") * 3 + this.ts.getInt("UB4") + this.ts.getInt("SB2");
        int b = this.sumColumnSize(columns);
        int out = 0;
        out = a > b ? a + this.ts.getInt("SB2") : b + this.ts.getInt("SB2");
        return out;
    }

    private int getOverHead(int length) {
        if (length <= 255) {
            return 1;
        }
        return 3;
    }

    private int getColumnSize(String columnType, int length) {
        String type = columnType.toUpperCase();
        if ("CHAR".equals(type)) {
            return length;
        }
        if ("VARCHAR2".equals(type)) {
            return length;
        }
        if ("NUMBER".equals(type)) {
            return 1 + (int)Math.ceil(length / 2) + 1;
        }
        if ("DATE".equals(type)) {
            return 7;
        }
        throw new IllegalStateException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u306a\u3044\u578b\u3067\u3059 \u578b:" + columnType);
    }

    private int getColumnSizeAddOverHead(String columnType, int length) {
        int normal = this.getColumnSize(columnType, length);
        int out = normal + this.getOverHead(normal);
        return out;
    }

    private int sumColumnSize(IColumn[] columns) throws Exception {
        int columnHeader = 3 * this.ts.getInt("UB1");
        int sum = 0;
        int i = 0;
        while (i < columns.length) {
            IColumn column = columns[i];
            sum += this.getColumnSizeAddOverHead(column.getColumn_type(), column.getColumn_length());
            ++i;
        }
        int out = columnHeader + sum;
        return out;
    }
}

