/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.core.StringUtil;
import zigen.plugin.db.ext.oracle.internal.ExplainTreeModel;
import zigen.plugin.db.ext.oracle.internal.Messages;

public class ExplainResultDialog
extends Dialog {
    ImageCacher ic = ImageCacher.getInstance();
    public static final int ID_COPY = -100;
    private ExplainTreeModel model;
    private TreeViewer result;
    private static final String[] HEADER = new String[]{"RESULT", "ACCESS_PREDICATES", "FILTER_PREDICATES"};

    public ExplainResultDialog(Shell parent, ExplainTreeModel model) {
        super(parent);
        Dialog.setDefaultImage((Image)ImageCacher.getInstance().getImage("db.gif"));
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.model = model;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("ExplainResultDialog.3"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, -100, Messages.getString("ExplainResultDialog.2"), false);
        this.createButton(parent, 0, Messages.getString("ExplainResultDialog.1"), true);
    }

    public boolean close() {
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == -100) {
            StringBuffer sb = new StringBuffer();
            Clipboard clipboard = ClipboardUtils.getInstance();
            ITableLabelProvider provider = (ITableLabelProvider)this.result.getLabelProvider();
            this.copyResult(sb, provider, this.model.getChildren(), 0);
            System.out.println(sb.toString());
            clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.result = new TreeViewer(composite, 68354);
        this.result.getControl().setLayoutData((Object)new GridData(1808));
        Tree tree = this.result.getTree();
        tree.setFont(DbPlugin.getDefaultFont());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.setHeaderColumn(tree);
        this.result.setLabelProvider((IBaseLabelProvider)new ColumnSelectLabelProvider());
        this.result.setContentProvider((IContentProvider)new ColumnSelectContentProvider());
        this.result.setInput((Object)this.model);
        this.result.expandAll();
        this.columnsPack(tree);
        return composite;
    }

    private void copyResult(StringBuffer sb, ITableLabelProvider provider, ExplainTreeModel[] nodes, int depth) {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        int i = 0;
        while (i < nodes.length) {
            ExplainTreeModel model = nodes[i];
            if (depth > 0) {
                String indent = StringUtil.padding(" ", depth * 2);
                sb.append(indent);
            }
            sb.append(provider.getColumnText((Object)model, 0));
            sb.append("\t");
            String str = provider.getColumnText((Object)model, 1);
            if (str != null) {
                sb.append(str);
            }
            sb.append("\t");
            str = provider.getColumnText((Object)model, 2);
            if (str != null) {
                sb.append(str);
            }
            sb.append(DbPluginConstant.LINE_SEP);
            this.copyResult(sb, provider, model.getChildren(), depth + 1);
            ++i;
        }
    }

    private void setHeaderColumn(Tree tree) {
        int i = 0;
        while (i < HEADER.length) {
            TreeColumn col = new TreeColumn(tree, 16384);
            col.setText(HEADER[i]);
            col.pack();
            ++i;
        }
    }

    private void columnsPack(Tree tree) {
        tree.setVisible(false);
        TreeColumn[] cols = tree.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
        tree.setVisible(true);
    }

    protected Point getInitialSize() {
        return new Point(800, 400);
    }

    private class ColumnSelectContentProvider
    implements ITreeContentProvider {
        private ColumnSelectContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ExplainTreeModel model = (ExplainTreeModel)parentElement;
            return model.getChildren();
        }

        public Object getParent(Object element) {
            ExplainTreeModel model = (ExplainTreeModel)element;
            return model.getParent();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private class ColumnSelectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ColumnSelectLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            block8: {
                try {
                    if (obj instanceof ExplainTreeModel) {
                        ExplainTreeModel model = (ExplainTreeModel)obj;
                        switch (index) {
                            case 0: {
                                return this.getResult(model);
                            }
                            case 1: {
                                return model.getAccess_predicates();
                            }
                            case 2: {
                                return model.getFilter_predicates();
                            }
                        }
                        break block8;
                    }
                    throw new RuntimeException("Unknown Type");
                }
                catch (Exception e) {
                    DbPlugin.log(e);
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return null;
        }

        private String getResult(ExplainTreeModel model) {
            StringBuffer sb = new StringBuffer();
            if (model.getParent_id() < 0) {
                sb.append(model.getOperation());
                sb.append(" ");
                sb.append(model.getOptions());
                sb.append(" ");
                sb.append(model.getObject_name());
                sb.append(" ");
                sb.append(model.getObject_type());
                sb.append(" Cost = ");
                sb.append(model.getPosition());
            } else {
                sb.append(model.getOperation());
                sb.append(" ");
                sb.append(model.getOptions());
                sb.append(" ");
                sb.append(model.getObject_name());
                sb.append(" ");
                sb.append(model.getObject_type());
            }
            return sb.toString();
        }
    }
}

