/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ext.oracle.internal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.ResultSetUtil;
import zigen.plugin.db.core.StatementUtil;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.ext.oracle.internal.ExplainVo;

public class ExplainDao {
    public ExplainVo[] execute(IDBConfig config) throws Exception {
        Connection con = Transaction.getInstance(config).getConnection();
        return this.execute(con);
    }

    public ExplainVo[] execute(Connection con) throws Exception {
        ExplainVo[] explainVoArray;
        ArrayList<Object> list = new ArrayList<Object>();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = con.createStatement();
            rs = st.executeQuery(this.getQuery());
            while (rs.next()) {
                list.add(this.parse(rs));
            }
            explainVoArray = list.toArray(new ExplainVo[0]);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ResultSetUtil.close(rs);
                StatementUtil.close(st);
                throw throwable;
            }
        }
        ResultSetUtil.close(rs);
        StatementUtil.close(st);
        return explainVoArray;
    }

    private String getQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT");
        sb.append("         ID");
        sb.append("         ,PARENT_ID");
        sb.append("         ,POSITION");
        sb.append("         ,OPERATION");
        sb.append("         ,OPTIONS");
        sb.append("         ,OBJECT_NAME");
        sb.append("         ,OBJECT_TYPE");
        sb.append("         ,COST");
        sb.append("         ,CARDINALITY");
        sb.append("         ,BYTES");
        sb.append("         ,ACCESS_PREDICATES");
        sb.append("         ,FILTER_PREDICATES");
        sb.append("     FROM");
        sb.append("         PLAN_TABLE");
        sb.append("     ORDER BY");
        sb.append("         ID");
        sb.append("         ,PARENT_ID");
        return sb.toString();
    }

    public Object parse(ResultSet rs) throws Exception {
        ExplainVo vo = new ExplainVo();
        int i = 0;
        vo.setId(rs.getBigDecimal(++i));
        vo.setParent_id(rs.getBigDecimal(++i));
        vo.setPosition(rs.getBigDecimal(++i));
        vo.setOperation(rs.getString(++i));
        vo.setOptions(rs.getString(++i));
        vo.setObject_name(rs.getString(++i));
        vo.setObject_type(rs.getString(++i));
        vo.setCost(rs.getBigDecimal(++i));
        vo.setCardinality(rs.getBigDecimal(++i));
        vo.setBytes(rs.getBigDecimal(++i));
        vo.setAccess_predicates(rs.getString(++i));
        vo.setFilter_predicates(rs.getString(++i));
        return vo;
    }
}

