/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.diff.DDL;
import zigen.plugin.db.diff.DDLDiff;
import zigen.plugin.db.diff.DDLDiffEditorInput;
import zigen.plugin.db.diff.IDDLDiff;
import zigen.plugin.db.diff.Messages;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.views.ColumnSearchAction;

public class DDLDiffForTableAction
extends Action
implements Runnable {
    private StructuredViewer viewer = null;
    private ITable left = null;
    private ITable right = null;

    public DDLDiffForTableAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText(Messages.getString("DDLDiffForTableAction.0"));
        this.setToolTipText(Messages.getString("DDLDiffForTableAction.1"));
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        try {
            int index = 0;
            for (Object obj : selection) {
                if (!(obj instanceof ITable)) continue;
                ITable table = (ITable)obj;
                if (index == 0) {
                    this.left = table;
                    ++index;
                    continue;
                }
                if (index != 1) break;
                this.right = table;
                ++index;
            }
            if (index == 2) {
                this.loadColumnInfo(this.left);
                this.loadColumnInfo(this.right);
                this.showDDLDiff();
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void showDDLDiff() throws Exception {
        DDLDiff diff = new DDLDiff(new DDL(this.left), new DDL(this.right));
        DDLDiffEditorInput input = new DDLDiffEditorInput(new IDDLDiff[]{diff}, true);
        IWorkbenchPage page = DbPlugin.getDefault().getPage();
        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.diff.DDLDiffEditor", (boolean)true);
    }

    private void loadColumnInfo(ITable table) {
        if (!table.isExpanded()) {
            table.setExpanded(true);
            Display display = Display.getDefault();
            display.syncExec((Runnable)new ColumnSearchAction(this.viewer, table));
        }
    }
}

