/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IProgressConstants;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableConstraintColumn;
import zigen.plugin.db.core.TableFKColumn;
import zigen.plugin.db.core.TableIDXColumn;
import zigen.plugin.db.core.TablePKColumn;
import zigen.plugin.db.core.rule.DefaultColumnSearcherFactory;
import zigen.plugin.db.core.rule.DefaultConstraintSearcherFactory;
import zigen.plugin.db.core.rule.IColumnSearcherFactory;
import zigen.plugin.db.core.rule.IConstraintSearcherFactory;
import zigen.plugin.db.diff.DDL;
import zigen.plugin.db.diff.DDLDiff;
import zigen.plugin.db.diff.DDLDiffEditorInput;
import zigen.plugin.db.diff.DDLNode;
import zigen.plugin.db.diff.IDDL;
import zigen.plugin.db.diff.IDDLDiff;
import zigen.plugin.db.diff.Messages;
import zigen.plugin.db.diff.SourceDDL;
import zigen.plugin.db.diff.SourceDDLDiff;
import zigen.plugin.db.ext.oracle.internal.OracleIndexSearcher;
import zigen.plugin.db.ext.oracle.internal.OracleSynonymInfoSearcher;
import zigen.plugin.db.ext.oracle.internal.SynonymInfo;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.OracleColumn;
import zigen.plugin.db.ui.internal.Synonym;
import zigen.plugin.db.ui.jobs.AbstractJob;

public class DDLDiffForFolderJob
extends AbstractJob {
    public static final String TargetFolderPattern = "^TABLE|^VIEW|^SYNONYM|^ALIAS";
    public static final String TargetFolderPattern2 = "^FUNCTION|^PROCEDURE|^PACKAGE";
    private TreeViewer viewer;
    private List allTables = new ArrayList();
    private List ddlList = new ArrayList();
    private Map map1 = new HashMap();
    private Map map2 = new HashMap();
    private Folder f1;
    private Folder f2;

    public DDLDiffForFolderJob(TreeViewer viewer, Folder f1, Folder f2) {
        super(Messages.getString("DDLDiffJob.0"));
        this.f1 = f1;
        this.f2 = f2;
        this.viewer = viewer;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        try {
            this.setProperty(IProgressConstants.ICON_PROPERTY, null);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Folder folder1 = (Folder)this.f1.clone();
            folder1.setParent(this.f1.getParent());
            Folder folder2 = (Folder)this.f2.clone();
            folder2.setParent(this.f2.getParent());
            if (this.loadAll(monitor, folder1, this.map1) != Status.OK_STATUS) {
                return Status.CANCEL_STATUS;
            }
            result = this.loadAll(monitor, folder2, this.map2);
            Collections.sort(this.allTables);
            Iterator iter = this.allTables.iterator();
            while (iter.hasNext()) {
                DDLNode diff;
                IDDL ddl1;
                if (monitor.isCanceled()) break;
                String keyword = (String)iter.next();
                Object obj1 = this.map1.get(keyword);
                Object obj2 = this.map2.get(keyword);
                if (obj1 != null && obj2 != null) {
                    DDLNode diff2;
                    IDDL ddl2;
                    if (obj1 instanceof DDL && obj2 instanceof DDL) {
                        ddl1 = (DDL)obj1;
                        ddl2 = (DDL)obj2;
                        diff2 = new DDLDiff((DDL)ddl1, (DDL)ddl2);
                        this.ddlList.add(diff2);
                        continue;
                    }
                    if (!(obj1 instanceof SourceDDL) || !(obj2 instanceof SourceDDL)) continue;
                    ddl1 = (SourceDDL)obj1;
                    ddl2 = (SourceDDL)obj2;
                    diff2 = new SourceDDLDiff((SourceDDL)ddl1, (SourceDDL)ddl2);
                    this.ddlList.add(diff2);
                    continue;
                }
                if (obj1 == null) {
                    IDDL ddl2;
                    if (obj2 instanceof DDL) {
                        ddl2 = (DDL)obj2;
                        diff = new DDLDiff(null, (DDL)ddl2);
                        this.ddlList.add(diff);
                        continue;
                    }
                    if (!(obj2 instanceof SourceDDL)) continue;
                    ddl2 = (SourceDDL)obj2;
                    diff = new SourceDDLDiff(null, (SourceDDL)ddl2);
                    this.ddlList.add(diff);
                    continue;
                }
                if (obj2 != null) continue;
                if (obj1 instanceof DDL) {
                    ddl1 = (DDL)obj1;
                    diff = new DDLDiff((DDL)ddl1, null);
                    this.ddlList.add(diff);
                    continue;
                }
                if (!(obj1 instanceof SourceDDL)) continue;
                ddl1 = (SourceDDL)obj1;
                diff = new SourceDDLDiff((SourceDDL)ddl1, null);
                this.ddlList.add(diff);
            }
            monitor.done();
            this.showResults(new ShowDiffView());
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private IStatus loadAll(IProgressMonitor monitor, Folder targetFolder, Map map) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void loadColumn(IProgressMonitor monitor, Connection con, ITable table, boolean convertUnicode) throws Exception {
        TablePKColumn[] pks = null;
        TableFKColumn[] fks = null;
        TableConstraintColumn[] cons = null;
        TableIDXColumn[] uidxs = null;
        TableIDXColumn[] nonuidxs = null;
        String schemaName = table.getSchemaName();
        String tableName = table.getName();
        switch (DBType.getType(con.getMetaData())) {
            case 1: {
                Bookmark bm;
                if (table.getName().toUpperCase().indexOf("BIN$") >= 0) {
                    return;
                }
                if (table instanceof Synonym) {
                    Synonym synonym = (Synonym)table;
                    schemaName = synonym.getTable_owner();
                    tableName = synonym.getTable_name();
                    break;
                }
                if (!(table instanceof Bookmark) || !(bm = (Bookmark)table).isSynonym()) break;
                SynonymInfo info = OracleSynonymInfoSearcher.execute(con, bm.getSchemaName(), bm.getName());
                schemaName = info.getTable_owner();
                tableName = info.getTable_name();
            }
        }
        IDBConfig config = table.getDbConfig();
        IColumnSearcherFactory factory = DefaultColumnSearcherFactory.getFactory(config);
        TableColumn[] columns = factory.execute(con, schemaName, tableName);
        IConstraintSearcherFactory constraintFactory = DefaultConstraintSearcherFactory.getFactory(config);
        pks = constraintFactory.getPKColumns(con, schemaName, tableName);
        fks = constraintFactory.getFKColumns(con, schemaName, tableName);
        if (!table.getFolderName().equals("VIEW")) {
            switch (DBType.getType(con.getMetaData())) {
                case 1: {
                    cons = constraintFactory.getConstraintColumns(con, schemaName, tableName);
                    uidxs = OracleIndexSearcher.getIDXColumns(con, schemaName, tableName, true);
                    nonuidxs = OracleIndexSearcher.getIDXColumns(con, schemaName, tableName, false);
                    break;
                }
                default: {
                    uidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, true);
                    nonuidxs = constraintFactory.getUniqueIDXColumns(con, schemaName, tableName, false);
                }
            }
        }
        table.setTablePKColumns(pks);
        table.setTableFKColumns(fks);
        table.setTableConstraintColumns(cons);
        table.setTableUIDXColumns(uidxs);
        table.setTableNonUIDXColumns(nonuidxs);
        int i = 0;
        while (i < columns.length) {
            TableColumn w_column = columns[i];
            TablePKColumn w_pk = this.getPKColumn(pks, w_column);
            TableFKColumn[] w_fks = this.getFKColumns(fks, w_column);
            this.addChild(con, table, w_column, w_pk, w_fks);
            ++i;
        }
    }

    private void addChild(Connection con, ITable table, TableColumn w_column, TablePKColumn w_pk, TableFKColumn[] w_fks) throws Exception {
        switch (DBType.getType(con.getMetaData())) {
            case 1: {
                table.addChild(new OracleColumn(w_column, w_pk, w_fks));
                break;
            }
            default: {
                table.addChild(new Column(w_column, w_pk, w_fks));
            }
        }
    }

    private TablePKColumn getPKColumn(TablePKColumn[] pks, TableColumn column) throws Exception {
        TablePKColumn pk = null;
        int i = 0;
        while (i < pks.length) {
            if (pks[i].getColumnName().equals(column.getColumnName())) {
                pk = pks[i];
                break;
            }
            ++i;
        }
        return pk;
    }

    private TableFKColumn[] getFKColumns(TableFKColumn[] fks, TableColumn column) throws Exception {
        ArrayList<TableFKColumn> list = new ArrayList<TableFKColumn>();
        int i = 0;
        while (i < fks.length) {
            if (fks[i].getColumnName().equals(column.getColumnName())) {
                list.add(fks[i]);
            }
            ++i;
        }
        return list.toArray(new TableFKColumn[0]);
    }

    public class ShowDiffView
    implements Runnable {
        public void run() {
            try {
                IDDLDiff[] diffs = DDLDiffForFolderJob.this.ddlList.toArray(new IDDLDiff[0]);
                DDLDiffEditorInput input = new DDLDiffEditorInput(diffs, false);
                IWorkbenchPage page = DbPlugin.getDefault().getPage();
                IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.diff.DDLDiffEditor", (boolean)true);
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }
    }
}

