/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.ClipboardUtils;
import zigen.plugin.db.diff.DDLDiffEditor;
import zigen.plugin.db.diff.DDLNode;
import zigen.plugin.db.ui.internal.Folder;

public class CopyNodeNameAction
extends Action {
    DDLDiffEditor editor;
    StructuredViewer viewer = null;
    protected IStructuredSelection selection;

    public CopyNodeNameAction() {
        this.setImage(4);
    }

    public void run() {
        try {
            StringBuffer sb = new StringBuffer();
            Clipboard clipboard = ClipboardUtils.getInstance();
            int index = 0;
            for (Object obj : this.selection) {
                if (obj instanceof Folder) {
                    Folder folder = (Folder)obj;
                    sb.append("[");
                    sb.append(folder.getName());
                    sb.append("]");
                    sb.append(DbPluginConstant.LINE_SEP);
                } else if (obj instanceof DDLNode) {
                    DDLNode node = (DDLNode)obj;
                    if (index == 0) {
                        sb.append(node.getName());
                        sb.append(DbPluginConstant.LINE_SEP);
                    } else {
                        sb.append(node.getName());
                        sb.append(DbPluginConstant.LINE_SEP);
                    }
                }
                ++index;
            }
            if (index > 0) {
                clipboard.setContents(new Object[]{sb.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    public void refresh() {
        if (this.editor == null) {
            this.setEnabled(false);
        } else if (this.viewer == null) {
            this.setEnabled(false);
        } else {
            this.selection = (IStructuredSelection)this.viewer.getSelection();
            if (this.selection.size() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    public void selectionChanged(ISelection _selection) {
        this.selection = _selection instanceof IStructuredSelection ? (IStructuredSelection)_selection : null;
    }

    public void setActiveEditor(DDLDiffEditor target) {
        if (target != null) {
            this.editor = target;
            this.viewer = target.getTreeViewer();
        } else {
            this.editor = null;
            this.viewer = null;
        }
    }

    public void setImage(int operation) {
        String imageName = null;
        switch (operation) {
            case 4: {
                imageName = "IMG_TOOL_COPY";
                this.setText("COPY");
                this.setAccelerator(262211);
                break;
            }
        }
        if (imageName != null) {
            this.setImageDescriptor(imageName);
        }
    }

    protected void setImageDescriptor(String imageName) {
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageName));
    }
}

