/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.csv;

import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableManager;
import zigen.plugin.db.csv.CSVConfig;
import zigen.plugin.db.csv.CSVWriter;
import zigen.plugin.db.csv.Messages;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;

public class CreateCSVForTableAction
extends Action {
    protected TableViewEditorFor31 editor;
    private IPreferenceStore store;

    public CreateCSVForTableAction() {
        this.setText(Messages.getString("CreateCSVForTableAction.0"));
        this.setToolTipText(Messages.getString("CreateCSVForTableAction.1"));
        this.store = DbPlugin.getDefault().getPreferenceStore();
    }

    public void setActiveEditor(TableViewEditorFor31 editor) {
        this.editor = editor;
    }

    public void run() {
        this.invoke();
    }

    private void invoke() {
        try {
            Shell shell = DbPlugin.getDefault().getShell();
            FileDialog dialog = new FileDialog(shell, 8192);
            dialog.setFileName(this.editor.getTableNode().getName());
            dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
            dialog.setFilterNames(new String[]{Messages.getString("CreateCSVForTableAction.4"), Messages.getString("CreateCSVForTableAction.5")});
            String fileName = dialog.open();
            if (fileName == null) {
                return;
            }
            File csvFile = new File(fileName);
            if (csvFile.exists()) {
                MessageBox msg = new MessageBox(shell, 196);
                msg.setMessage(String.valueOf(fileName) + Messages.getString("CreateCSVForTableAction.6"));
                msg.setText(Messages.getString("CreateCSVForTableAction.7"));
                int res2 = msg.open();
                if (res2 == 128) {
                    return;
                }
            }
            CSVConfig config = new CSVConfig();
            String encoding = this.store.getString("CSVPreferencePage.Encoding");
            String separator = this.store.getString("CSVPreferencePage.Demiliter");
            boolean nonHeader = this.store.getBoolean("CSVPreferencePage.NonHeader");
            boolean nonDoubleQuate = this.store.getBoolean("CSVPreferencePage.NonDoubleQuate");
            String condition = this.editor.getCondition();
            if (condition == null || condition.length() == 0) {
                config.setQuery(TableManager.getSQLForCSV(this.editor.getTableNode()));
            } else {
                config.setQuery(TableManager.getSQLForCSV(this.editor.getTableNode(), condition));
            }
            config.setCsvEncoding(encoding);
            config.setSeparator(separator);
            config.setNonHeader(nonHeader);
            config.setNonDoubleQuate(nonDoubleQuate);
            config.setCsvFile(fileName);
            CSVWriter writer = new CSVWriter(this.editor.getDBConfig(), config);
            writer.execute();
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

